@if ($item['show_condition'])
    @php
        $href =
            $item['route_slug'] && \App\Helpers\Classes\Helper::hasRoute($item['route'])
                ? route($item['route'], $item['route_slug'])
                : (\App\Helpers\Classes\Helper::hasRoute($item['route'])
                    ? route($item['route'])
                    : '');
        $is_active = $href === url()->current() || activeRoute(...$item['active_condition'] ?: []);
    @endphp

    @php
        // code for apply theme default icons:
        $classicThemeSet = [
            'dashboard' => [
                'key' => 'dashboard',
                'icon' => null,
                'svg' =>
                    '<svg width="18" height="18" viewBox="0 0 18 18" fill="currentColor" xmlns="http://www.w3.org/2000/svg"> <path d="M2 18C1.45 18 0.979167 17.8042 0.5875 17.4125C0.195833 17.0208 0 16.55 0 16V9.75H7V18H2ZM9 18V9.75H18V16C18 16.55 17.8042 17.0208 17.4125 17.4125C17.0208 17.8042 16.55 18 16 18H9ZM0 7.75V2C0 1.45 0.195833 0.979167 0.5875 0.5875C0.979167 0.195833 1.45 0 2 0H16C16.55 0 17.0208 0.195833 17.4125 0.5875C17.8042 0.979167 18 1.45 18 2V7.75H0Z" /> </svg>',
            ],
            'documents' => [
                'key' => 'documents',
                'icon' => null,
                'svg' =>
                    '<svg width="21" height="18" viewBox="0 0 21 18" fill="currentColor" xmlns="http://www.w3.org/2000/svg"> <path d="M12 18V14.925L17.525 9.425C17.675 9.275 17.8417 9.16667 18.025 9.1C18.2083 9.03333 18.3917 9 18.575 9C18.775 9 18.9667 9.0375 19.15 9.1125C19.3333 9.1875 19.5 9.3 19.65 9.45L20.575 10.375C20.7083 10.525 20.8125 10.6917 20.8875 10.875C20.9625 11.0583 21 11.2417 21 11.425C21 11.6083 20.9667 11.7958 20.9 11.9875C20.8333 12.1792 20.725 12.35 20.575 12.5L15.075 18H12ZM18.575 12.4L19.5 11.425L18.575 10.5L17.625 11.45L18.575 12.4ZM2 16C1.45 16 0.979167 15.8042 0.5875 15.4125C0.195833 15.0208 0 14.55 0 14V2C0 1.45 0.195833 0.979167 0.5875 0.5875C0.979167 0.195833 1.45 0 2 0H8L10 2H18C18.55 2 19.0208 2.19583 19.4125 2.5875C19.8042 2.97917 20 3.45 20 4V7.3C19.7667 7.2 19.525 7.125 19.275 7.075C19.025 7.025 18.775 7 18.525 7C18.0583 7 17.6208 7.08333 17.2125 7.25C16.8042 7.41667 16.4333 7.66667 16.1 8L10 14.1V16H2Z" /> </svg>',
            ],
            'ai_editor' => [
                'key' => 'ai_editor',
                'icon' => null,
                'svg' =>
                    '<svg width="22" height="19" viewBox="0 0 22 19" fill="currentColor" xmlns="http://www.w3.org/2000/svg"> <path d="M12.775 2H6V0H14.775L12.775 2ZM8.775 6H3V4H10.775L8.775 6ZM4.775 10H0V8H6.775L4.775 10ZM9.6 8L15 13.4L10 18.4C9.6 18.8 9.13333 19 8.6 19C8.06667 19 7.6 18.8 7.2 18.4L7.15 18.35L6.5 19H1.5L4.65 15.85L4.6 15.8C4.2 15.4 4 14.9333 4 14.4C4 13.8667 4.2 13.4 4.6 13L9.6 8ZM11.025 6.575L16 1.6C16.4 1.2 16.8667 1 17.4 1C17.9333 1 18.4 1.2 18.8 1.6L21.4 4.2C21.8 4.6 22 5.06667 22 5.6C22 6.13333 21.8 6.6 21.4 7L16.425 11.975L11.025 6.575Z"/> </svg>',
            ],
            'ext_chat_bot' => [
                'key' => 'ext_chat_bot',
                'icon' => null,
                'svg' =>
                    '<svg xmlns="http://www.w3.org/2000/svg" height="24px" viewBox="0 -960 960 960" width="24px" fill="currentColor"><path d="M160-360q-50 0-85-35t-35-85q0-50 35-85t85-35v-80q0-33 23.5-56.5T240-760h120q0-50 35-85t85-35q50 0 85 35t35 85h120q33 0 56.5 23.5T800-680v80q50 0 85 35t35 85q0 50-35 85t-85 35v160q0 33-23.5 56.5T720-120H240q-33 0-56.5-23.5T160-200v-160Zm200-80q25 0 42.5-17.5T420-500q0-25-17.5-42.5T360-560q-25 0-42.5 17.5T300-500q0 25 17.5 42.5T360-440Zm240 0q25 0 42.5-17.5T660-500q0-25-17.5-42.5T600-560q-25 0-42.5 17.5T540-500q0 25 17.5 42.5T600-440ZM320-280h320v-80H320v80Z"/></svg>',
            ],
            'ai_realtime_voice_chat' => [
                'key' => 'ai_realtime_voice_chat',
                'icon' => null,
                'svg' =>
                    '<svg xmlns="http://www.w3.org/2000/svg" height="24px" viewBox="0 -960 960 960" width="24px" fill="currentColor"><path d="M80-80v-80q46 0 91-6t88-22q-46-23-72.5-66.5T160-349v-91h160v-120h135L324-822l72-36 131 262q20 40-3 78t-68 38h-56v40q0 33-23.5 56.5T320-360h-80v11q0 35 21.5 61.5T316-252l12 3q40 10 45 50t-31 60q-60 33-126.5 46T80-80Zm572-114-57-56q21-21 33-48.5t12-59.5q0-32-12-59.5T595-466l57-57q32 32 50 74.5t18 90.5q0 48-18 90t-50 74ZM765-80l-57-57q43-43 67.5-99.5T800-358q0-66-24.5-122T708-579l57-57q54 54 84.5 125T880-358q0 81-30.5 152.5T765-80Z"/></svg>',
            ],
            'seo_tool_extension' => [
                'key' => 'seo_tool_extension',
                'icon' => null,
                'svg' =>
                    '<svg xmlns="http://www.w3.org/2000/svg" height="24px" viewBox="0 -960 960 960" width="24px" fill="currentColor"><path d="M660-200q42 0 71-29t29-71q0-42-29-71t-71-29q-42 0-71 29t-29 71q0 42 29 71t71 29ZM864-40 756-147q-21 13-45.5 20t-50.5 7q-75 0-127.5-52.5T480-300q0-75 52.5-127.5T660-480q75 0 127.5 52.5T840-300q0 27-7.5 51.5T812-203L920-96l-56 56ZM200-80q-33 0-56.5-23.5T120-160v-640q0-33 23.5-56.5T200-880h320l240 240v100q-24-10-49-15t-51-5q-56 0-104.5 21T472-480H280v80h140q-8 19-12.5 39t-6.5 41H280v80h127q11 50 40 91.5T521-80H200Zm280-520h200L480-800l200 200-200-200v200Z"/></svg>',
            ],
            'ext_chat_bot_agent' => [
                'key' => 'ext_chat_bot_agent',
                'icon' => null,
                'svg' =>
                    '<svg xmlns="http://www.w3.org/2000/svg" height="24px" viewBox="0 -960 960 960" width="24px" fill="currentColor"><path d="M760-720q-50 0-85-35t-35-85q0-50 35-85t85-35q50 0 85 35t35 85q0 50-35 85t-85 35ZM80-80v-720q0-33 23.5-56.5T160-880h404q-4 20-4 40t4 40q5 23 14 43t22 37H240v80h520q32 0 63-10t57-30v360q0 33-23.5 56.5T800-240H240L80-80Zm160-440h480v-80H240v80Zm0 120h320v-80H240v80Z"/></svg>',
            ],
            'ext_social_media' => [
                'key' => 'ext_social_media',
                'icon' => null,
                'svg' =>
                    '<svg xmlns="http://www.w3.org/2000/svg" height="24px" viewBox="0 -960 960 960" width="24px" fill="currentColor"><path d="M680-80q-50 0-85-35t-35-85q0-6 3-28L282-392q-16 15-37 23.5t-45 8.5q-50 0-85-35t-35-85q0-50 35-85t85-35q24 0 45 8.5t37 23.5l281-164q-2-7-2.5-13.5T560-760q0-50 35-85t85-35q50 0 85 35t35 85q0 50-35 85t-85 35q-24 0-45-8.5T598-672L317-508q2 7 2.5 13.5t.5 14.5q0 8-.5 14.5T317-452l281 164q16-15 37-23.5t45-8.5q50 0 85 35t35 85q0 50-35 85t-85 35Z"/></svg>',
            ],
            'ai_social_media_extension' => [
                'key' => 'ai_social_media_extension',
                'icon' => null,
                'svg' =>
                    '<svg xmlns="http://www.w3.org/2000/svg" height="24px" viewBox="0 -960 960 960" width="24px" fill="currentColor"><path d="M680-80q-50 0-85-35t-35-85q0-6 3-28L282-392q-16 15-37 23.5t-45 8.5q-50 0-85-35t-35-85q0-50 35-85t85-35q24 0 45 8.5t37 23.5l281-164q-2-7-2.5-13.5T560-760q0-50 35-85t85-35q50 0 85 35t35 85q0 50-35 85t-85 35q-24 0-45-8.5T598-672L317-508q2 7 2.5 13.5t.5 14.5q0 8-.5 14.5T317-452l281 164q16-15 37-23.5t45-8.5q50 0 85 35t35 85q0 50-35 85t-85 35Z"/></svg>',
            ],
            'ai_detector_extension' => [
                'key' => 'ai_detector_extension',
                'icon' => null,
                'svg' =>
                    '<svg xmlns="http://www.w3.org/2000/svg" height="24px" viewBox="0 -960 960 960" width="24px" fill="currentColor"><path d="M80-720v-200h200v80H160v120H80Zm720 0v-120H680v-80h200v200h-80ZM80-40v-200h80v120h120v80H80Zm600 0v-80h120v-120h80v200H680ZM280-160q-33 0-56.5-23.5T200-240v-480q0-33 23.5-56.5T280-800h400q33 0 56.5 23.5T760-720v480q0 33-23.5 56.5T680-160H280Zm80-400h240v-80H360v80Zm0 120h240v-80H360v80Zm0 120h240v-80H360v80Z"/></svg>',
            ],
            'scheduled_posts_extension' => [
                'key' => 'scheduled_posts_extension',
                'icon' => null,
                'svg' =>
                    '<svg xmlns="http://www.w3.org/2000/svg" height="24px" viewBox="0 -960 960 960" width="24px" fill="currentColor"><path d="m787-145 28-28-75-75v-112h-40v128l87 87ZM720-40q-83 0-141.5-58.5T520-240q0-83 58.5-141.5T720-440q83 0 141.5 58.5T920-240q0 83-58.5 141.5T720-40ZM280-600h400v-80H280v80Zm187 480H200q-33 0-56.5-23.5T120-200v-560q0-33 23.5-56.5T200-840h560q33 0 56.5 23.5T840-760v268q-29-14-58.5-21t-61.5-7q-11 0-20.5.5T680-517v-3H280v80h245q-18 17-32.5 37T467-360H280v80h163q-2 10-2.5 19.5T440-240q0 33 6 61.5t21 58.5Z"/></svg>',
            ],
            'ai_plagiarism_extension' => [
                'key' => 'ai_plagiarism_extension',
                'icon' => null,
                'svg' =>
                    '<svg xmlns="http://www.w3.org/2000/svg" height="24px" viewBox="0 -960 960 960" width="24px" fill="currentColor"><path d="m438-240 226-226-58-58-169 169-84-84-57 57 142 142ZM240-80q-33 0-56.5-23.5T160-160v-640q0-33 23.5-56.5T240-880h320l240 240v480q0 33-23.5 56.5T720-80H240Zm280-520h200L520-800v200Z"/></svg>',
            ],
            'ai_video_to_video' => [
                'key' => 'ai_video_to_video',
                'icon' => null,
                'svg' =>
                    '<svg xmlns="http://www.w3.org/2000/svg" height="24px" viewBox="0 -960 960 960" width="24px" fill="currentColor"><path d="M140-640q38-109 131.5-174.5T480-880q82 0 155.5 35T760-746v-134h80v240H600v-80h76q-39-39-90-59.5T480-800q-81 0-149.5 43T227-640h-87ZM280-80q-33 0-56.5-23.5T200-160v-320q0-33 23.5-56.5T280-560h320q33 0 56.5 23.5T680-480v120l120-120v320L680-280v120q0 33-23.5 56.5T600-80H280Z"/></svg>',
            ],
            'photo_studio_extension' => [
                'key' => 'photo_studio_extension',
                'icon' => null,
                'svg' =>
                    '<svg xmlns="http://www.w3.org/2000/svg" height="24px" viewBox="0 -960 960 960" width="24px" fill="currentColor"><path d="M240-120q-17 0-28.5-11.5T200-160v-40h-80q-33 0-56.5-23.5T40-280v-440q0-33 23.5-56.5T120-800h720q33 0 56.5 23.5T920-720v440q0 33-23.5 56.5T840-200h-80v40q0 17-11.5 28.5T720-120H240Zm-40-240h560L580-600 440-420 340-540 200-360Z"/></svg>',
            ],
            'ai_web_chat_extension' => [
                'key' => 'ai_web_chat_extension',
                'icon' => null,
                'svg' =>
                    '<svg xmlns="http://www.w3.org/2000/svg" height="24px" viewBox="0 -960 960 960" width="24px" fill="currentColor"><path d="M480-80q-83 0-156-31.5T197-197q-54-54-85.5-127T80-480q0-83 31.5-156T197-763q54-54 127-85.5T480-880q83 0 156 31.5T763-763q54 54 85.5 127T880-480q0 83-31.5 156T763-197q-54 54-127 85.5T480-80Zm-40-82v-78q-33 0-56.5-23.5T360-320v-40L168-552q-3 18-5.5 36t-2.5 36q0 121 79.5 212T440-162Zm276-102q41-45 62.5-100.5T800-480q0-98-54.5-179T600-776v16q0 33-23.5 56.5T520-680h-80v80q0 17-11.5 28.5T400-560h-80v80h240q17 0 28.5 11.5T600-440v120h40q26 0 47 15.5t29 40.5Z"/></svg>',
            ],
            'ai_voice_isolator' => [
                'key' => 'ai_voice_isolator',
                'icon' => null,
                'svg' =>
                    '<svg xmlns="http://www.w3.org/2000/svg" height="24px" viewBox="0 -960 960 960" width="24px" fill="currentColor"><path d="M240-80q62 0 101.5-31t60.5-91q17-50 32.5-70t71.5-64q62-50 98-113t36-151q0-119-80.5-199.5T360-880q-119 0-199.5 80.5T80-600h80q0-85 57.5-142.5T360-800q85 0 142.5 57.5T560-600q0 68-27 116t-77 86q-52 38-81 74t-43 78q-14 44-33.5 65T240-160q-33 0-56.5-23.5T160-240H80q0 66 47 113t113 47Zm120-420q42 0 71-29.5t29-70.5q0-42-29-71t-71-29q-42 0-71 29t-29 71q0 41 29 70.5t71 29.5Zm380 121-59-59q19-37 29-77.5t10-84.5q0-44-10-84t-29-77l59-59q29 49 44.5 104.5T800-600q0 61-15.5 116.5T740-379Zm117 116-59-58q39-60 60.5-130T880-598q0-78-21.5-148.5T797-877l60-60q49 72 76 157.5T960-600q0 94-27 179.5T857-263Z"/></svg>',
            ],
            'ai_tavus' => [
                'key' => 'ai_tavus',
                'icon' => null,
                'svg' =>
                    '<svg xmlns="http://www.w3.org/2000/svg" height="24px" viewBox="0 -960 960 960" width="24px" fill="currentColor"><path d="M224-81q-33 4-59-16t-30-53L80-587q-5-32 15.5-58t54.5-31l50-6v362q0 51 34.5 85.5T320-200h410q0 27-21 44t-48 21L224-81Zm136-199q-34 0-57-23t-23-57v-440q0-33 23-56.5t57-23.5h235q-8 20-11.5 40t-3.5 41q0 15 1.5 30t6.5 29h-8q-46 0-78 32.5T470-630q0 46 32 78t78 32q40 0 70-25t38-65q26 15 54 23t57 8q20 0 40.5-4t40.5-12v235q0 34-23.5 57T800-280H360Zm0-80h440v-32q-45-42-102-65t-118-23q-62 0-118.5 23T360-392v32Zm347-340 71-200h44l72 200h-43l-15-44h-72l-15 44h-42Zm67-74h52l-26-82-26 82Z"/></svg>',
            ],
            'ai_product_shot' => [
                'key' => 'ai_product_shot',
                'icon' => null,
                'svg' =>
                    '<svg xmlns="http://www.w3.org/2000/svg" height="24px" viewBox="0 -960 960 960" width="24px" fill="currentColor"><path d="M581-400q68 0 115.5-47T749-560q-68 0-116.5 47T581-400Zm0 0q-3-66-51.5-113T413-560q5 66 52.5 113T581-400Zm0-120q17 0 28.5-11.5T621-560v-10l10 4q15 6 30.5 3t23.5-17q9-15 6-32t-20-24l-10-4 10-4q17-7 19.5-24.5T685-700q-9-15-24-17.5t-30 3.5l-10 4v-10q0-17-11.5-28.5T581-760q-17 0-28.5 11.5T541-720v10l-10-4q-15-6-30-3.5T477-700q-8 14-5.5 31.5T491-644l10 4-10 4q-17 7-20 24t6 32q8 14 23.5 17t30.5-3l10-4v10q0 17 11.5 28.5T581-520Zm0-80q-17 0-28.5-11.5T541-640q0-17 11.5-28.5T581-680q17 0 28.5 11.5T621-640q0 17-11.5 28.5T581-600ZM228-85q-33 5-59.5-15.5T138-154L85-591q-4-33 16-59t53-30l46-6v326q0 66 47 113t113 47h372q-6 24-24 41.5T664-138L228-85Zm132-195q-33 0-56.5-23.5T280-360v-440q0-33 23.5-56.5T360-880h440q33 0 56.5 23.5T880-800v440q0 33-23.5 56.5T800-280H360Z"/></svg>',
            ],
            'ai_persona' => [
                'key' => 'ai_persona',
                'icon' => null,
                'svg' =>
                    '<svg xmlns="http://www.w3.org/2000/svg" height="24px" viewBox="0 -960 960 960" width="24px" fill="currentColor"><path d="M360-390q-21 0-35.5-14.5T310-440q0-21 14.5-35.5T360-490q21 0 35.5 14.5T410-440q0 21-14.5 35.5T360-390Zm240 0q-21 0-35.5-14.5T550-440q0-21 14.5-35.5T600-490q21 0 35.5 14.5T650-440q0 21-14.5 35.5T600-390ZM480-160q134 0 227-93t93-227q0-24-3-46.5T786-570q-21 5-42 7.5t-44 2.5q-91 0-172-39T390-708q-32 78-91.5 135.5T160-486v6q0 134 93 227t227 93Zm0 80q-83 0-156-31.5T197-197q-54-54-85.5-127T80-480q0-83 31.5-156T197-763q54-54 127-85.5T480-880q83 0 156 31.5T763-763q54 54 85.5 127T880-480q0 83-31.5 156T763-197q-54 54-127 85.5T480-80Z"/></svg>',
            ],
            'ai_avatar' => [
                'key' => 'ai_avatar',
                'icon' => null,
                'svg' =>
                    '<svg xmlns="http://www.w3.org/2000/svg" height="24px" viewBox="0 -960 960 960" width="24px" fill="currentColor"><path d="M360-120v-200q-62-5-121.5-14T120-360l20-80q83 23 168 31.5t172 8.5q86 0 171-8.5T820-440l20 80q-60 17-119.5 26T600-320v200H360Zm120-320q-34 0-57-23t-23-57q0-33 23-56.5t57-23.5q33 0 56.5 23.5T560-520q0 34-23.5 57T480-440ZM180-560q-26 0-43-17t-17-43q0-25 17-42.5t43-17.5q25 0 42.5 17.5T240-620q0 26-17.5 43T180-560Zm600 0q-26 0-43-17t-17-43q0-25 17-42.5t43-17.5q25 0 42.5 17.5T840-620q0 26-17.5 43T780-560ZM290-710q-26 0-43-17t-17-43q0-25 17-42.5t43-17.5q25 0 42.5 17.5T350-770q0 26-17.5 43T290-710Zm380 0q-26 0-43-17t-17-43q0-25 17-42.5t43-17.5q25 0 42.5 17.5T730-770q0 26-17.5 43T670-710Zm-190-50q-26 0-43-17t-17-43q0-25 17-42.5t43-17.5q25 0 42.5 17.5T540-820q0 26-17.5 43T480-760Z"/></svg>',
            ],
            'ai_video_pro' => [
                'key' => 'ai_video_pro',
                'icon' => null,
                'svg' =>
                    '<svg xmlns="http://www.w3.org/2000/svg" height="24px" viewBox="0 -960 960 960" width="24px" fill="currentColor"><path d="M240-320h320v-128l160 128v-320L560-512v-128H240v320Zm-80 160q-33 0-56.5-23.5T80-240v-480q0-33 23.5-56.5T160-800h640q33 0 56.5 23.5T880-720v480q0 33-23.5 56.5T800-160H160Z"/></svg>',
            ],
            'ai_music' => [
                'key' => 'ai_music',
                'icon' => null,
                'svg' =>
                    '<svg xmlns="http://www.w3.org/2000/svg" height="24px" viewBox="0 -960 960 960" width="24px" fill="currentColor"><path d="M420-280q42 0 71-29t29-71v-220h120v-80H480v220q-13-9-28-14.5t-32-5.5q-42 0-71 29t-29 71q0 42 29 71t71 29ZM160-160q-33 0-56.5-23.5T80-240v-480q0-33 23.5-56.5T160-800h640q33 0 56.5 23.5T880-720v480q0 33-23.5 56.5T800-160H160Z"/></svg>',
            ],
            'advanced_image' => [
                'key' => 'advanced_image',
                'icon' => null,
                'svg' =>
                    '<svg xmlns="http://www.w3.org/2000/svg" height="24px" viewBox="0 -960 960 960" width="24px" fill="currentColor"><path d="M120-200q-33 0-56.5-23.5T40-280v-400q0-33 23.5-56.5T120-760h400q33 0 56.5 23.5T600-680v400q0 33-23.5 56.5T520-200H120Zm600-320q-17 0-28.5-11.5T680-560v-160q0-17 11.5-28.5T720-760h160q17 0 28.5 11.5T920-720v160q0 17-11.5 28.5T880-520H720ZM160-360h320L375-500l-75 100-55-73-85 113Zm560 160q-17 0-28.5-11.5T680-240v-160q0-17 11.5-28.5T720-440h160q17 0 28.5 11.5T920-400v160q0 17-11.5 28.5T880-200H720Z"/></svg>',
            ],
            'announcements' => [
                'key' => 'announcements',
                'icon' => null,
                'svg' =>
                    '<svg xmlns="http://www.w3.org/2000/svg" height="24px" viewBox="0 -960 960 960" width="24px" fill="currentColor"><path d="M720-440v-80h160v80H720Zm48 280-128-96 48-64 128 96-48 64Zm-80-480-48-64 128-96 48 64-128 96ZM200-200v-160h-40q-33 0-56.5-23.5T80-440v-80q0-33 23.5-56.5T160-600h160l200-120v480L320-360h-40v160h-80Zm360-146v-268q27 24 43.5 58.5T620-480q0 41-16.5 75.5T560-346Z"/></svg>',
            ],
            'onboarding' => [
                'key' => 'onboarding',
                'icon' => null,
                'svg' =>
                    '<svg xmlns="http://www.w3.org/2000/svg" height="24px" viewBox="0 -960 960 960" width="24px" fill="currentColor"><path d="M200-80v-760h640l-80 200 80 200H280v360h-80Z"/></svg>',
            ],
            'mailchimp_newsletter' => [
                'key' => 'mailchimp_newsletter',
                'icon' => null,
                'svg' =>
                    '<svg xmlns="http://www.w3.org/2000/svg" height="24px" viewBox="0 -960 960 960" width="24px" fill="currentColor"><path d="M120-80q-17 0-28.5-11.5T80-120v-320q0-17 11.5-28.5T120-480h120v-160q0-100 70-170t170-70h160q100 0 170 70t70 170v560h-80v-120H640v80q0 17-11.5 28.5T600-80H120Zm240-136 200-114v-70L360-286 160-400v70l200 114Zm280-64h160v-360q0-66-47-113t-113-47H480q-66 0-113 47t-47 113v160h280q17 0 28.5 11.5T640-440v160ZM400-560v-80h320v80H400Z"/></svg>',
            ],
            'onboarding_pro_extension' => [
                'key' => 'onboarding_pro_extension',
                'icon' => null,
                'svg' =>
                    '<svg xmlns="http://www.w3.org/2000/svg" height="24px" viewBox="0 -960 960 960" width="24px" fill="currentColor"><path d="M200-120v-680h250q-5 19-7.5 37.5T440-726q0 121 84 200.5T720-446q20 0 40-3t40-9v138H520l-16-80H280v280h-80Zm520-806q83 0 141.5 58.5T920-726q0 83-58.5 141.5T720-526q-83 0-141.5-58.5T520-726q0-83 58.5-141.5T720-926Zm-29 290 139-138-42-42-97 95-39-39-42 43 81 81Z"/></svg>',
            ],
            'ai_writer' => [
                'key' => 'ai_writer',
                'icon' => null,
                'svg' =>
                    '<svg width="22" height="16" viewBox="0 0 22 16" fill="currentColor" xmlns="http://www.w3.org/2000/svg"> <path d="M4.95 14C3.28333 13.9167 2.04167 13.5667 1.225 12.95C0.408333 12.3333 0 11.4417 0 10.275C0 9.19167 0.445833 8.3125 1.3375 7.6375C2.22917 6.9625 3.46667 6.55833 5.05 6.425C5.7 6.375 6.1875 6.27083 6.5125 6.1125C6.8375 5.95417 7 5.73333 7 5.45C7 5.01667 6.75417 4.69167 6.2625 4.475C5.77083 4.25833 4.95833 4.1 3.825 4L4 2C5.71667 2.13333 6.97917 2.47917 7.7875 3.0375C8.59583 3.59583 9 4.4 9 5.45C9 6.33333 8.67917 7.025 8.0375 7.525C7.39583 8.025 6.45 8.325 5.2 8.425C4.13333 8.50833 3.33333 8.70417 2.8 9.0125C2.26667 9.32083 2 9.74167 2 10.275C2 10.8583 2.23333 11.2792 2.7 11.5375C3.16667 11.7958 3.95 11.95 5.05 12L4.95 14ZM12.875 13.25L8.75 9.125L17.375 0.5C17.7083 0.166667 18.1042 0 18.5625 0C19.0208 0 19.4167 0.166667 19.75 0.5L21.5 2.25C21.8333 2.58333 22 2.97917 22 3.4375C22 3.89583 21.8333 4.29167 21.5 4.625L12.875 13.25ZM7.975 15C7.69167 15.0667 7.44167 14.9917 7.225 14.775C7.00833 14.5583 6.93333 14.3083 7 14.025L7.775 10.25L11.725 14.2L7.975 15Z" /> </svg>',
            ],
            'ai_video' => [
                'key' => 'ai_video',
                'icon' => null,
                'svg' =>
                    '<svg width="21" height="20" viewBox="0 0 21 20" fill="currentColor" xmlns="http://www.w3.org/2000/svg"> <path d="M9.99914 11.5L15.9991 7.5L9.99914 3.5V11.5ZM7.02414 15C6.47414 15 6.00331 14.8042 5.61164 14.4125C5.21997 14.0208 5.02414 13.55 5.02414 13V2C5.02414 1.45 5.21997 0.979167 5.61164 0.5875C6.00331 0.195833 6.47414 0 7.02414 0H18.0241C18.5741 0 19.045 0.195833 19.4366 0.5875C19.8283 0.979167 20.0241 1.45 20.0241 2V13C20.0241 13.55 19.8283 14.0208 19.4366 14.4125C19.045 14.8042 18.5741 15 18.0241 15H7.02414ZM3.72414 19.875C3.17414 19.9583 2.68247 19.825 2.24914 19.475C1.81581 19.125 1.56581 18.675 1.49914 18.125L0.149139 7.2C0.0824724 6.65 0.219972 6.15833 0.561639 5.725C0.903306 5.29167 1.34914 5.04167 1.89914 4.975L3.02414 4.85V14C3.02414 14.8333 3.31581 15.5417 3.89914 16.125C4.48247 16.7083 5.19081 17 6.02414 17H16.2991C16.1991 17.4 15.9991 17.7458 15.6991 18.0375C15.3991 18.3292 15.0325 18.5 14.5991 18.55L3.72414 19.875Z" /> </svg>',
            ],
            'ai_image_generator' => [
                'key' => 'ai_image_generator',
                'icon' => null,
                'svg' =>
                    '<svg width="22" height="20" viewBox="0 0 22 20" fill="currentColor" xmlns="http://www.w3.org/2000/svg"> <path d="M18 6V4H16V2H18V0H20V2H22V4H20V6H18ZM10 16.5C11.25 16.5 12.3125 16.0625 13.1875 15.1875C14.0625 14.3125 14.5 13.25 14.5 12C14.5 10.75 14.0625 9.6875 13.1875 8.8125C12.3125 7.9375 11.25 7.5 10 7.5C8.75 7.5 7.6875 7.9375 6.8125 8.8125C5.9375 9.6875 5.5 10.75 5.5 12C5.5 13.25 5.9375 14.3125 6.8125 15.1875C7.6875 16.0625 8.75 16.5 10 16.5ZM10 14.5C9.3 14.5 8.70833 14.2583 8.225 13.775C7.74167 13.2917 7.5 12.7 7.5 12C7.5 11.3 7.74167 10.7083 8.225 10.225C8.70833 9.74167 9.3 9.5 10 9.5C10.7 9.5 11.2917 9.74167 11.775 10.225C12.2583 10.7083 12.5 11.3 12.5 12C12.5 12.7 12.2583 13.2917 11.775 13.775C11.2917 14.2583 10.7 14.5 10 14.5ZM2 20C1.45 20 0.979167 19.8042 0.5875 19.4125C0.195833 19.0208 0 18.55 0 18V6C0 5.45 0.195833 4.97917 0.5875 4.5875C0.979167 4.19583 1.45 4 2 4H5.15L7 2H14V6H16V8H20V18C20 18.55 19.8042 19.0208 19.4125 19.4125C19.0208 19.8042 18.55 20 18 20H2Z" /> </svg>',
            ],
            'ai_article_wizard' => [
                'key' => 'ai_article_wizard',
                'icon' => null,
                'svg' =>
                    '<svg width="20" height="20" viewBox="0 0 20 20" fill="currentColor" xmlns="http://www.w3.org/2000/svg"> <path d="M11.6459 5.33848C9.22145 4.83023 7.32648 2.93527 6.81832 0.51082C6.7559 0.213203 6.4934 0 6.18922 0C5.88504 0 5.62254 0.213203 5.56016 0.510859C5.05195 2.93527 3.15699 4.83019 0.732578 5.33836C0.434922 5.40074 0.22168 5.66328 0.22168 5.96742C0.22168 6.27156 0.434883 6.5341 0.732578 6.59648C3.15695 7.10473 5.05184 8.99965 5.56004 11.4241C5.62242 11.7217 5.88492 11.935 6.1891 11.935C6.49324 11.935 6.75578 11.7218 6.81816 11.4241C7.32641 8.99965 9.22141 7.10473 11.6458 6.5966C11.9435 6.53422 12.1567 6.27172 12.1567 5.96754C12.1567 5.6634 11.9435 5.40086 11.6459 5.33848Z"/> <path d="M10.5834 15.9564C9.44109 15.717 8.54828 14.8242 8.30879 13.6818C8.24641 13.3842 7.98391 13.1709 7.67973 13.1709C7.37559 13.1709 7.11305 13.3841 7.05066 13.6818C6.81117 14.8241 5.91832 15.7169 4.77605 15.9564C4.4784 16.0187 4.26516 16.2813 4.26516 16.5854C4.26516 16.8896 4.47836 17.1521 4.77605 17.2145C5.91828 17.4539 6.81113 18.3468 7.05059 19.4891C7.11297 19.7868 7.37547 20 7.67965 20C7.98379 20 8.24633 19.7868 8.30871 19.4891C8.5482 18.3468 9.44105 17.454 10.5834 17.2145C10.881 17.1521 11.0943 16.8896 11.0943 16.5855C11.0943 16.2813 10.8811 16.0188 10.5834 15.9564Z"/> <path d="M19.2671 10.0053C17.7232 9.6816 16.5164 8.4748 16.1928 6.93086C16.1304 6.6332 15.8679 6.41996 15.5637 6.41996C15.2596 6.41996 14.997 6.63312 14.9346 6.93082C14.611 8.4748 13.4042 9.68156 11.8602 10.0052C11.5626 10.0676 11.3493 10.3301 11.3493 10.6343C11.3493 10.9384 11.5625 11.2009 11.8602 11.2633C13.4042 11.587 14.6109 12.7937 14.9346 14.3377C14.997 14.6354 15.2595 14.8486 15.5636 14.8486C15.8678 14.8486 16.1303 14.6355 16.1927 14.3377C16.5164 12.7937 17.7232 11.587 19.2671 11.2634C19.5648 11.201 19.778 10.9385 19.778 10.6343C19.778 10.3302 19.5648 10.0677 19.2671 10.0053Z"/> </svg>',
            ],
            'ai_pdf' => [
                'key' => 'ai_pdf',
                'icon' => null,
                'svg' =>
                    '<svg width="20" height="22" viewBox="0 0 20 22" fill="currentColor" xmlns="http://www.w3.org/2000/svg"> <path d="M0 5V0H5V2H2V5H0ZM18 5V2H15V0H20V5H18ZM0 22V17H2V20H5V22H0ZM15 22V20H18V17H20V22H15ZM5 19C4.45 19 3.97917 18.8042 3.5875 18.4125C3.19583 18.0208 3 17.55 3 17V5C3 4.45 3.19583 3.97917 3.5875 3.5875C3.97917 3.19583 4.45 3 5 3H15C15.55 3 16.0208 3.19583 16.4125 3.5875C16.8042 3.97917 17 4.45 17 5V17C17 17.55 16.8042 18.0208 16.4125 18.4125C16.0208 18.8042 15.55 19 15 19H5ZM7 9H13V7H7V9ZM7 12H13V10H7V12ZM7 15H13V13H7V15Z" /> </svg>',
            ],
            'ai_vision' => [
                'key' => 'ai_vision',
                'icon' => null,
                'svg' =>
                    '<svg width="22" height="15" viewBox="0 0 22 15" fill="currentColor" xmlns="http://www.w3.org/2000/svg"> <path d="M11 12C12.25 12 13.3125 11.5625 14.1875 10.6875C15.0625 9.8125 15.5 8.75 15.5 7.5C15.5 6.25 15.0625 5.1875 14.1875 4.3125C13.3125 3.4375 12.25 3 11 3C9.75 3 8.6875 3.4375 7.8125 4.3125C6.9375 5.1875 6.5 6.25 6.5 7.5C6.5 8.75 6.9375 9.8125 7.8125 10.6875C8.6875 11.5625 9.75 12 11 12ZM11 10.2C10.25 10.2 9.6125 9.9375 9.0875 9.4125C8.5625 8.8875 8.3 8.25 8.3 7.5C8.3 6.75 8.5625 6.1125 9.0875 5.5875C9.6125 5.0625 10.25 4.8 11 4.8C11.75 4.8 12.3875 5.0625 12.9125 5.5875C13.4375 6.1125 13.7 6.75 13.7 7.5C13.7 8.25 13.4375 8.8875 12.9125 9.4125C12.3875 9.9375 11.75 10.2 11 10.2ZM11 15C8.56667 15 6.35 14.3208 4.35 12.9625C2.35 11.6042 0.9 9.78333 0 7.5C0.9 5.21667 2.35 3.39583 4.35 2.0375C6.35 0.679167 8.56667 0 11 0C13.4333 0 15.65 0.679167 17.65 2.0375C19.65 3.39583 21.1 5.21667 22 7.5C21.1 9.78333 19.65 11.6042 17.65 12.9625C15.65 14.3208 13.4333 15 11 15Z" /> </svg>',
            ],
            'ai_rewriter' => [
                'key' => 'ai_rewriter',
                'icon' => null,
                'svg' =>
                    '<svg width="20" height="21" viewBox="0 0 20 21" fill="currentColor" xmlns="http://www.w3.org/2000/svg"> <path d="M6 15V10.75L15.175 1.575C15.375 1.375 15.6 1.225 15.85 1.125C16.1 1.025 16.35 0.974998 16.6 0.974998C16.8667 0.974998 17.1208 1.025 17.3625 1.125C17.6042 1.225 17.825 1.375 18.025 1.575L19.425 3C19.6083 3.2 19.75 3.42083 19.85 3.6625C19.95 3.90417 20 4.15 20 4.4C20 4.65 19.9542 4.89583 19.8625 5.1375C19.7708 5.37917 19.625 5.6 19.425 5.8L10.25 15H6ZM16.6 5.8L18.025 4.4L16.625 3L15.2 4.4L16.6 5.8ZM2 21C1.45 21 0.979167 20.8042 0.5875 20.4125C0.195833 20.0208 0 19.55 0 19V5C0 4.45 0.195833 3.97917 0.5875 3.5875C0.979167 3.19583 1.45 3 2 3H10.925L4 9.925V17H11.05L18 10.05V19C18 19.55 17.8042 20.0208 17.4125 20.4125C17.0208 20.8042 16.55 21 16 21H2Z" /> </svg>',
            ],
            'ai_chat_image' => [
                'key' => 'ai_chat_image',
                'icon' => null,
                'svg' =>
                    '<svg width="20" height="20" viewBox="0 0 20 20" fill="currentColor" xmlns="http://www.w3.org/2000/svg"> <path d="M4 12H16L12.25 7L9.25 11L7 8L4 12ZM0 20V2C0 1.45 0.195833 0.979167 0.5875 0.5875C0.979167 0.195833 1.45 -1.19209e-07 2 -1.19209e-07H18C18.55 -1.19209e-07 19.0208 0.195833 19.4125 0.5875C19.8042 0.979167 20 1.45 20 2V14C20 14.55 19.8042 15.0208 19.4125 15.4125C19.0208 15.8042 18.55 16 18 16H4L0 20Z"/> </svg>',
            ],
            'ai_chat_all' => [
                'key' => 'ai_chat_all',
                'icon' => null,
                'svg' =>
                    '<svg width="20" height="20" viewBox="0 0 20 20" fill="currentColor" xmlns="http://www.w3.org/2000/svg"> <path d="M6 12H14V11.45C14 10.7167 13.6333 10.125 12.9 9.675C12.1667 9.225 11.2 9 10 9C8.8 9 7.83333 9.225 7.1 9.675C6.36667 10.125 6 10.7167 6 11.45V12ZM10 8C10.55 8 11.0208 7.80417 11.4125 7.4125C11.8042 7.02083 12 6.55 12 6C12 5.45 11.8042 4.97917 11.4125 4.5875C11.0208 4.19583 10.55 4 10 4C9.45 4 8.97917 4.19583 8.5875 4.5875C8.19583 4.97917 8 5.45 8 6C8 6.55 8.19583 7.02083 8.5875 7.4125C8.97917 7.80417 9.45 8 10 8ZM0 20V2C0 1.45 0.195833 0.979167 0.5875 0.5875C0.979167 0.195833 1.45 0 2 0H18C18.55 0 19.0208 0.195833 19.4125 0.5875C19.8042 0.979167 20 1.45 20 2V14C20 14.55 19.8042 15.0208 19.4125 15.4125C19.0208 15.8042 18.55 16 18 16H4L0 20Z" /> </svg>',
            ],
            'ai_code_generator' => [
                'key' => 'ai_code_generator',
                'icon' => null,
                'svg' =>
                    '<svg width="18" height="18" viewBox="0 0 18 18" fill="currentColor" xmlns="http://www.w3.org/2000/svg"> <path d="M6.6 12.6L8 11.175L5.825 9L8 6.825L6.6 5.4L3 9L6.6 12.6ZM11.4 12.6L15 9L11.4 5.4L10 6.825L12.175 9L10 11.175L11.4 12.6ZM2 18C1.45 18 0.979167 17.8042 0.5875 17.4125C0.195833 17.0208 0 16.55 0 16V2C0 1.45 0.195833 0.979167 0.5875 0.5875C0.979167 0.195833 1.45 0 2 0H16C16.55 0 17.0208 0.195833 17.4125 0.5875C17.8042 0.979167 18 1.45 18 2V16C18 16.55 17.8042 17.0208 17.4125 17.4125C17.0208 17.8042 16.55 18 16 18H2Z"/> </svg>',
            ],
            'ai_youtube' => [
                'key' => 'ai_youtube',
                'icon' => null,
                'svg' =>
                    '<svg width="20" height="15" viewBox="0 0 20 15" fill="currentColor" xmlns="http://www.w3.org/2000/svg"> <path d="M19.4417 2.55211C19.2568 1.53163 18.3759 0.788472 17.3536 0.556462C15.8238 0.23201 12.9926 0 9.92931 0C6.86786 0 3.9913 0.23201 2.45967 0.556462C1.43919 0.788472 0.556462 1.4845 0.371579 2.55211C0.184883 3.71216 0 5.33623 0 7.42432C0 9.51242 0.184883 11.1365 0.416893 12.2965C0.603589 13.317 1.4845 14.0602 2.50499 14.2922C4.12906 14.6166 6.91318 14.8486 9.97644 14.8486C13.0397 14.8486 15.8238 14.6166 17.4479 14.2922C18.4684 14.0602 19.3493 13.3641 19.536 12.2965C19.7209 11.1365 19.9529 9.46529 20 7.42432C19.9057 5.33623 19.6737 3.71216 19.4417 2.55211ZM7.42432 10.6725V4.17618L13.085 7.42432L7.42432 10.6725Z"/> </svg>',
            ],
            'ai_rss' => [
                'key' => 'ai_rss',
                'icon' => null,
                'svg' =>
                    '<svg width="17" height="17" viewBox="0 0 17 17" fill="currentColor" xmlns="http://www.w3.org/2000/svg"> <path d="M2 17C1.45 17 0.979167 16.8042 0.5875 16.4125C0.195833 16.0208 0 15.55 0 15C0 14.45 0.195833 13.9792 0.5875 13.5875C0.979167 13.1958 1.45 13 2 13C2.55 13 3.02083 13.1958 3.4125 13.5875C3.80417 13.9792 4 14.45 4 15C4 15.55 3.80417 16.0208 3.4125 16.4125C3.02083 16.8042 2.55 17 2 17ZM14 17C14 15.05 13.6333 13.2292 12.9 11.5375C12.1667 9.84583 11.1667 8.36667 9.9 7.1C8.63333 5.83333 7.15417 4.83333 5.4625 4.1C3.77083 3.36667 1.95 3 0 3V0C2.36667 0 4.575 0.441667 6.625 1.325C8.675 2.20833 10.475 3.425 12.025 4.975C13.575 6.525 14.7917 8.325 15.675 10.375C16.5583 12.425 17 14.6333 17 17H14ZM8 17C8 15.8833 7.79167 14.8458 7.375 13.8875C6.95833 12.9292 6.38333 12.0833 5.65 11.35C4.91667 10.6167 4.07083 10.0417 3.1125 9.625C2.15417 9.20833 1.11667 9 0 9V6C1.53333 6 2.9625 6.2875 4.2875 6.8625C5.6125 7.4375 6.775 8.225 7.775 9.225C8.775 10.225 9.5625 11.3875 10.1375 12.7125C10.7125 14.0375 11 15.4667 11 17H8Z"/> </svg>',
            ],
            'ai_speech_to_text' => [
                'key' => 'ai_speech_to_text',
                'icon' => null,
                'svg' =>
                    '<svg width="18" height="20" viewBox="0 0 18 20" fill="currentColor" xmlns="http://www.w3.org/2000/svg"> <path d="M4 16V4H6V16H4ZM8 20V0H10V20H8ZM0 12V8H2V12H0ZM12 16V4H14V16H12ZM16 12V8H18V12H16Z"/> </svg>',
            ],
            'ai_voiceover' => [
                'key' => 'ai_voiceover',
                'icon' => null,
                'svg' =>
                    '<svg width="22" height="19" viewBox="0 0 22 19" fill="currentColor" xmlns="http://www.w3.org/2000/svg"> <path d="M18.95 13.95L17.4 12.4C18.1333 11.7167 18.7083 10.9083 19.125 9.97499C19.5417 9.04165 19.75 8.04999 19.75 6.99999C19.75 5.94999 19.5417 4.96665 19.125 4.04999C18.7083 3.13332 18.1333 2.33332 17.4 1.64999L18.95 0.0499878C19.8833 0.933321 20.625 1.97499 21.175 3.17499C21.725 4.37499 22 5.64999 22 6.99999C22 8.34999 21.725 9.62499 21.175 10.825C20.625 12.025 19.8833 13.0667 18.95 13.95ZM15.75 10.75L14.15 9.14999C14.45 8.86665 14.6917 8.54582 14.875 8.18749C15.0583 7.82915 15.15 7.43332 15.15 6.99999C15.15 6.56665 15.0583 6.17082 14.875 5.81249C14.6917 5.45415 14.45 5.13332 14.15 4.84999L15.75 3.24999C16.2833 3.73332 16.7 4.29582 17 4.93749C17.3 5.57915 17.45 6.26665 17.45 6.99999C17.45 7.73332 17.3 8.42082 17 9.06249C16.7 9.70415 16.2833 10.2667 15.75 10.75ZM8 11C6.9 11 5.95833 10.6083 5.175 9.82499C4.39167 9.04165 4 8.09999 4 6.99999C4 5.89999 4.39167 4.95832 5.175 4.17499C5.95833 3.39165 6.9 2.99999 8 2.99999C9.1 2.99999 10.0417 3.39165 10.825 4.17499C11.6083 4.95832 12 5.89999 12 6.99999C12 8.09999 11.6083 9.04165 10.825 9.82499C10.0417 10.6083 9.1 11 8 11ZM0 19V16.2C0 15.65 0.141667 15.1333 0.425 14.65C0.708333 14.1667 1.1 13.8 1.6 13.55C2.45 13.1167 3.40833 12.75 4.475 12.45C5.54167 12.15 6.71667 12 8 12C9.28333 12 10.4583 12.15 11.525 12.45C12.5917 12.75 13.55 13.1167 14.4 13.55C14.9 13.8 15.2917 14.1667 15.575 14.65C15.8583 15.1333 16 15.65 16 16.2V19H0Z"/> </svg>',
            ],
            'ai_voiceover_clone' => [
                'key' => 'ai_voiceover_clone',
                'icon' => null,
                'svg' =>
                    '<svg width="24" height="18" viewBox="0 0 24 18" fill="currentColor" xmlns="http://www.w3.org/2000/svg"> <path d="M14 13H16V10H19V8H16V5H14V8H11V10H14V13ZM6 17.5C4.18333 16.8667 2.72917 15.7708 1.6375 14.2125C0.545833 12.6542 0 10.9167 0 9C0 7.08333 0.545833 5.34583 1.6375 3.7875C2.72917 2.22917 4.18333 1.13333 6 0.5V2.7C4.76667 3.28333 3.79167 4.14167 3.075 5.275C2.35833 6.40833 2 7.65 2 9C2 10.35 2.35833 11.5917 3.075 12.725C3.79167 13.8583 4.76667 14.7167 6 15.3V17.5ZM15 18C13.75 18 12.5792 17.7625 11.4875 17.2875C10.3958 16.8125 9.44583 16.1708 8.6375 15.3625C7.82917 14.5542 7.1875 13.6042 6.7125 12.5125C6.2375 11.4208 6 10.25 6 9C6 7.75 6.2375 6.57917 6.7125 5.4875C7.1875 4.39583 7.82917 3.44583 8.6375 2.6375C9.44583 1.82917 10.3958 1.1875 11.4875 0.7125C12.5792 0.2375 13.75 0 15 0C16.25 0 17.4208 0.2375 18.5125 0.7125C19.6042 1.1875 20.5542 1.82917 21.3625 2.6375C22.1708 3.44583 22.8125 4.39583 23.2875 5.4875C23.7625 6.57917 24 7.75 24 9C24 10.25 23.7625 11.4208 23.2875 12.5125C22.8125 13.6042 22.1708 14.5542 21.3625 15.3625C20.5542 16.1708 19.6042 16.8125 18.5125 17.2875C17.4208 17.7625 16.25 18 15 18Z"/> </svg>',
            ],
            'team_menu' => [
                'key' => 'team_menu',
                'icon' => null,
                'svg' =>
                    '<svg width="24" height="16" viewBox="0 0 24 16" fill="currentColor" xmlns="http://www.w3.org/2000/svg"> <path d="M12.5 7.95C12.9833 7.41667 13.3542 6.80833 13.6125 6.125C13.8708 5.44167 14 4.73333 14 4C14 3.26667 13.8708 2.55833 13.6125 1.875C13.3542 1.19167 12.9833 0.583333 12.5 0.05C13.5 0.183333 14.3333 0.625 15 1.375C15.6667 2.125 16 3 16 4C16 5 15.6667 5.875 15 6.625C14.3333 7.375 13.5 7.81667 12.5 7.95ZM18 16V13C18 12.4 17.8667 11.8292 17.6 11.2875C17.3333 10.7458 16.9833 10.2667 16.55 9.85C17.4 10.15 18.1875 10.5375 18.9125 11.0125C19.6375 11.4875 20 12.15 20 13V16H18ZM20 9V7H18V5H20V3H22V5H24V7H22V9H20ZM8 8C6.9 8 5.95833 7.60833 5.175 6.825C4.39167 6.04167 4 5.1 4 4C4 2.9 4.39167 1.95833 5.175 1.175C5.95833 0.391667 6.9 0 8 0C9.1 0 10.0417 0.391667 10.825 1.175C11.6083 1.95833 12 2.9 12 4C12 5.1 11.6083 6.04167 10.825 6.825C10.0417 7.60833 9.1 8 8 8ZM0 16V13.2C0 12.6333 0.145833 12.1125 0.4375 11.6375C0.729167 11.1625 1.11667 10.8 1.6 10.55C2.63333 10.0333 3.68333 9.64583 4.75 9.3875C5.81667 9.12917 6.9 9 8 9C9.1 9 10.1833 9.12917 11.25 9.3875C12.3167 9.64583 13.3667 10.0333 14.4 10.55C14.8833 10.8 15.2708 11.1625 15.5625 11.6375C15.8542 12.1125 16 12.6333 16 13.2V16H0Z"/> </svg>',
            ],
            'brand_voice' => [
                'key' => 'brand_voice',
                'icon' => null,
                'svg' =>
                    '<svg width="20" height="20" viewBox="0 0 20 20" fill="currentColor" xmlns="http://www.w3.org/2000/svg"> <path d="M2.65 20C1.75 20 1.08333 19.8167 0.65 19.45C0.216667 19.0833 0 18.5333 0 17.8C0 16.8333 0.408333 16.2167 1.225 15.95C2.04167 15.6833 3.00833 15.55 4.125 15.55H4.65V14.15C4.65 13.5833 4.64167 13.1208 4.625 12.7625C4.60833 12.4042 4.55833 12.1083 4.475 11.875C4.39167 11.6417 4.29583 11.4792 4.1875 11.3875C4.07917 11.2958 3.93333 11.25 3.75 11.25C3.6 11.25 3.4625 11.275 3.3375 11.325C3.2125 11.375 3.10833 11.4417 3.025 11.525C2.95833 11.6083 2.91667 11.6958 2.9 11.7875C2.88333 11.8792 2.89167 11.975 2.925 12.075C3.025 12.2583 3.14167 12.4375 3.275 12.6125C3.40833 12.7875 3.475 12.9917 3.475 13.225C3.475 13.6417 3.32917 13.9958 3.0375 14.2875C2.74583 14.5792 2.39167 14.725 1.975 14.725C1.55833 14.725 1.20417 14.5792 0.9125 14.2875C0.620833 13.9958 0.475 13.6417 0.475 13.225C0.475 12.775 0.575 12.4083 0.775 12.125C0.975 11.8417 1.24583 11.6167 1.5875 11.45C1.92917 11.2833 2.325 11.1667 2.775 11.1C3.225 11.0333 3.70833 11 4.225 11C5.64167 11 6.625 11.2542 7.175 11.7625C7.725 12.2708 8 13.1667 8 14.45V18.125C8 18.4417 8.0375 18.675 8.1125 18.825C8.1875 18.975 8.31667 19.05 8.5 19.05C8.7 19.05 8.8625 18.9 8.9875 18.6C9.1125 18.3 9.19167 17.8333 9.225 17.2H9.5C9.45 18.2333 9.25417 18.9583 8.9125 19.375C8.57083 19.7917 8 20 7.2 20C6.48333 20 5.92083 19.8875 5.5125 19.6625C5.10417 19.4375 4.84167 19.1 4.725 18.65C4.55833 19.1333 4.3125 19.4792 3.9875 19.6875C3.6625 19.8958 3.21667 20 2.65 20ZM11.975 20C11.6417 20 11.3708 19.8625 11.1625 19.5875C10.9542 19.3125 10.9167 19.0167 11.05 18.7L13.6 11.975C13.7167 11.6917 13.9 11.4583 14.15 11.275C14.4 11.0917 14.6833 11 15 11C15.3167 11 15.6 11.0917 15.85 11.275C16.1 11.4583 16.2833 11.6917 16.4 11.975L18.95 18.7C19.0833 19.0167 19.0458 19.3125 18.8375 19.5875C18.6292 19.8625 18.3583 20 18.025 20C17.825 20 17.6417 19.9417 17.475 19.825C17.3083 19.7083 17.1833 19.55 17.1 19.35L16.6 17.9H13.4L12.9 19.35C12.8333 19.5333 12.7167 19.6875 12.55 19.8125C12.3833 19.9375 12.1917 20 11.975 20ZM3.875 19.275C4.09167 19.275 4.275 19.1042 4.425 18.7625C4.575 18.4208 4.65 18.0083 4.65 17.525V15.85C4.21667 15.85 3.9 15.9792 3.7 16.2375C3.5 16.4958 3.4 16.9167 3.4 17.5V17.775C3.4 18.375 3.43333 18.775 3.5 18.975C3.56667 19.175 3.69167 19.275 3.875 19.275ZM14.05 16.15H15.975L15 13.3L14.05 16.15ZM13.125 9.025C12.325 9.025 11.6875 8.74583 11.2125 8.1875C10.7375 7.62917 10.5 6.875 10.5 5.925C10.5 4.19167 11.05 2.77083 12.15 1.6625C13.25 0.554167 14.6583 0 16.375 0C17.075 0 17.6417 0.0791667 18.075 0.2375C18.5083 0.395833 18.725 0.6 18.725 0.85C18.725 0.95 18.7083 1.05 18.675 1.15C18.6417 1.25 18.5833 1.34167 18.5 1.425C18.4167 1.54167 18.3125 1.625 18.1875 1.675C18.0625 1.725 17.9333 1.73333 17.8 1.7C17.5667 1.63333 17.3 1.575 17 1.525C16.7 1.475 16.425 1.45 16.175 1.45C14.9917 1.45 14.0417 1.85 13.325 2.65C12.6083 3.45 12.25 4.50833 12.25 5.825C12.25 6.19167 12.3167 6.575 12.45 6.975C12.5833 7.375 12.8833 7.575 13.35 7.575C13.5333 7.575 13.7125 7.53333 13.8875 7.45C14.0625 7.36667 14.2167 7.25 14.35 7.1C14.6333 6.8 14.8958 6.3 15.1375 5.6C15.3792 4.9 15.6 4.05 15.8 3.05C15.8333 2.83333 15.9208 2.67917 16.0625 2.5875C16.2042 2.49583 16.4 2.45 16.65 2.45C16.95 2.45 17.1792 2.52917 17.3375 2.6875C17.4958 2.84583 17.5417 3.04167 17.475 3.275C17.275 3.99167 17.1292 4.61667 17.0375 5.15C16.9458 5.68333 16.9 6.16667 16.9 6.6C16.9 6.93333 16.9458 7.175 17.0375 7.325C17.1292 7.475 17.2667 7.55 17.45 7.55C17.6333 7.55 17.8125 7.48333 17.9875 7.35C18.1625 7.21667 18.4083 6.96667 18.725 6.6C18.7583 6.55 18.8833 6.49167 19.1 6.425C19.2333 6.425 19.3333 6.475 19.4 6.575C19.4667 6.675 19.5 6.81667 19.5 7C19.5 7.46667 19.2333 7.91667 18.7 8.35C18.1667 8.78333 17.6083 9 17.025 9C16.5917 9 16.2208 8.88333 15.9125 8.65C15.6042 8.41667 15.3917 8.08333 15.275 7.65C15.025 8.08333 14.7167 8.42083 14.35 8.6625C13.9833 8.90417 13.575 9.025 13.125 9.025ZM1 9V3.5C1 2.53333 1.34167 1.70833 2.025 1.025C2.70833 0.341667 3.53333 0 4.5 0C5.46667 0 6.29167 0.341667 6.975 1.025C7.65833 1.70833 8 2.53333 8 3.5V9H6V7H3V9H1ZM3 5H6V3.5C6 3.08333 5.85417 2.72917 5.5625 2.4375C5.27083 2.14583 4.91667 2 4.5 2C4.08333 2 3.72917 2.14583 3.4375 2.4375C3.14583 2.72917 3 3.08333 3 3.5V5Z"/> </svg>',
            ],
            'api_keys' => [
                'key' => 'api_keys',
                'icon' => null,
                'svg' =>
                    '<svg width="22" height="12" viewBox="0 0 22 12" fill="currentColor" xmlns="http://www.w3.org/2000/svg"> <path d="M6 9C6.83333 9 7.54167 8.70833 8.125 8.125C8.70833 7.54167 9 6.83333 9 6C9 5.16667 8.70833 4.45833 8.125 3.875C7.54167 3.29167 6.83333 3 6 3C5.16667 3 4.45833 3.29167 3.875 3.875C3.29167 4.45833 3 5.16667 3 6C3 6.83333 3.29167 7.54167 3.875 8.125C4.45833 8.70833 5.16667 9 6 9ZM6 12C4.33333 12 2.91667 11.4167 1.75 10.25C0.583333 9.08333 0 7.66667 0 6C0 4.33333 0.583333 2.91667 1.75 1.75C2.91667 0.583333 4.33333 0 6 0C7.35 0 8.52917 0.383333 9.5375 1.15C10.5458 1.91667 11.25 2.86667 11.65 4H20.025L22 5.975L18.5 9.975L16 8L14 10L12 8H11.65C11.2333 9.2 10.5083 10.1667 9.475 10.9C8.44167 11.6333 7.28333 12 6 12Z"/> </svg>',
            ],
            'affiliates' => [
                'key' => 'affiliates',
                'icon' => null,
                'svg' =>
                    '<svg width="20" height="19" viewBox="0 0 20 19" fill="currentColor" xmlns="http://www.w3.org/2000/svg"> <path d="M2 15V17H18V15H2ZM2 4H4.2C4.11667 3.85 4.0625 3.69167 4.0375 3.525C4.0125 3.35833 4 3.18333 4 3C4 2.16667 4.29167 1.45833 4.875 0.875C5.45833 0.291667 6.16667 0 7 0C7.5 0 7.9625 0.129167 8.3875 0.3875C8.8125 0.645833 9.18333 0.966667 9.5 1.35L10 2L10.5 1.35C10.8 0.95 11.1667 0.625 11.6 0.375C12.0333 0.125 12.5 0 13 0C13.8333 0 14.5417 0.291667 15.125 0.875C15.7083 1.45833 16 2.16667 16 3C16 3.18333 15.9875 3.35833 15.9625 3.525C15.9375 3.69167 15.8833 3.85 15.8 4H18C18.55 4 19.0208 4.19583 19.4125 4.5875C19.8042 4.97917 20 5.45 20 6V17C20 17.55 19.8042 18.0208 19.4125 18.4125C19.0208 18.8042 18.55 19 18 19H2C1.45 19 0.979167 18.8042 0.5875 18.4125C0.195833 18.0208 0 17.55 0 17V6C0 5.45 0.195833 4.97917 0.5875 4.5875C0.979167 4.19583 1.45 4 2 4ZM2 12H18V6H12.9L15 8.85L13.4 10L10 5.4L6.6 10L5 8.85L7.05 6H2V12ZM7 4C7.28333 4 7.52083 3.90417 7.7125 3.7125C7.90417 3.52083 8 3.28333 8 3C8 2.71667 7.90417 2.47917 7.7125 2.2875C7.52083 2.09583 7.28333 2 7 2C6.71667 2 6.47917 2.09583 6.2875 2.2875C6.09583 2.47917 6 2.71667 6 3C6 3.28333 6.09583 3.52083 6.2875 3.7125C6.47917 3.90417 6.71667 4 7 4ZM13 4C13.2833 4 13.5208 3.90417 13.7125 3.7125C13.9042 3.52083 14 3.28333 14 3C14 2.71667 13.9042 2.47917 13.7125 2.2875C13.5208 2.09583 13.2833 2 13 2C12.7167 2 12.4792 2.09583 12.2875 2.2875C12.0958 2.47917 12 2.71667 12 3C12 3.28333 12.0958 3.52083 12.2875 3.7125C12.4792 3.90417 12.7167 4 13 4Z" /> </svg>',
            ],
            'support' => [
                'key' => 'support',
                'icon' => null,
                'svg' =>
                    '<svg width="20" height="20" viewBox="0 0 20 20" fill="currentColor" xmlns="http://www.w3.org/2000/svg"> <path d="M10 20C8.61667 20 7.31667 19.7375 6.1 19.2125C4.88333 18.6875 3.825 17.975 2.925 17.075C2.025 16.175 1.3125 15.1167 0.7875 13.9C0.2625 12.6833 0 11.3833 0 10C0 8.61667 0.2625 7.31667 0.7875 6.1C1.3125 4.88333 2.025 3.825 2.925 2.925C3.825 2.025 4.88333 1.3125 6.1 0.7875C7.31667 0.2625 8.61667 0 10 0C11.3833 0 12.6833 0.2625 13.9 0.7875C15.1167 1.3125 16.175 2.025 17.075 2.925C17.975 3.825 18.6875 4.88333 19.2125 6.1C19.7375 7.31667 20 8.61667 20 10C20 11.3833 19.7375 12.6833 19.2125 13.9C18.6875 15.1167 17.975 16.175 17.075 17.075C16.175 17.975 15.1167 18.6875 13.9 19.2125C12.6833 19.7375 11.3833 20 10 20ZM7.1 17.45L8.3 14.7C7.6 14.45 6.99583 14.0625 6.4875 13.5375C5.97917 13.0125 5.58333 12.4 5.3 11.7L2.55 12.85C2.93333 13.9167 3.525 14.85 4.325 15.65C5.125 16.45 6.05 17.05 7.1 17.45ZM5.3 8.3C5.58333 7.6 5.97917 6.9875 6.4875 6.4625C6.99583 5.9375 7.6 5.55 8.3 5.3L7.15 2.55C6.08333 2.95 5.15 3.55 4.35 4.35C3.55 5.15 2.95 6.08333 2.55 7.15L5.3 8.3ZM10 13C10.8333 13 11.5417 12.7083 12.125 12.125C12.7083 11.5417 13 10.8333 13 10C13 9.16667 12.7083 8.45833 12.125 7.875C11.5417 7.29167 10.8333 7 10 7C9.16667 7 8.45833 7.29167 7.875 7.875C7.29167 8.45833 7 9.16667 7 10C7 10.8333 7.29167 11.5417 7.875 12.125C8.45833 12.7083 9.16667 13 10 13ZM12.9 17.45C13.95 17.05 14.8708 16.4542 15.6625 15.6625C16.4542 14.8708 17.05 13.95 17.45 12.9L14.7 11.7C14.45 12.4 14.0667 13.0042 13.55 13.5125C13.0333 14.0208 12.4333 14.4167 11.75 14.7L12.9 17.45ZM14.7 8.25L17.45 7.1C17.05 6.05 16.4542 5.12917 15.6625 4.3375C14.8708 3.54583 13.95 2.95 12.9 2.55L11.75 5.35C12.4333 5.6 13.025 5.97917 13.525 6.4875C14.025 6.99583 14.4167 7.58333 14.7 8.25Z"/> </svg>',
            ],
            'integration' => [
                'key' => 'integration',
                'icon' => 'tabler-webhook',
                'svg' => null,
            ],
            'admin_dashboard' => [
                'key' => 'admin_dashboard',
                'icon' => null,
                'svg' =>
                    '<svg width="20" height="20" viewBox="0 0 20 20" fill="currentColor" xmlns="http://www.w3.org/2000/svg"> <path d="M10 11C10.2833 11 10.5208 10.9042 10.7125 10.7125C10.9042 10.5208 11 10.2833 11 10C11 9.71667 10.9042 9.47917 10.7125 9.2875C10.5208 9.09583 10.2833 9 10 9C9.71667 9 9.47917 9.09583 9.2875 9.2875C9.09583 9.47917 9 9.71667 9 10C9 10.2833 9.09583 10.5208 9.2875 10.7125C9.47917 10.9042 9.71667 11 10 11ZM13 11C13.2833 11 13.5208 10.9042 13.7125 10.7125C13.9042 10.5208 14 10.2833 14 10C14 9.71667 13.9042 9.47917 13.7125 9.2875C13.5208 9.09583 13.2833 9 13 9C12.7167 9 12.4792 9.09583 12.2875 9.2875C12.0958 9.47917 12 9.71667 12 10C12 10.2833 12.0958 10.5208 12.2875 10.7125C12.4792 10.9042 12.7167 11 13 11ZM7 11C7.28333 11 7.52083 10.9042 7.7125 10.7125C7.90417 10.5208 8 10.2833 8 10C8 9.71667 7.90417 9.47917 7.7125 9.2875C7.52083 9.09583 7.28333 9 7 9C6.71667 9 6.47917 9.09583 6.2875 9.2875C6.09583 9.47917 6 9.71667 6 10C6 10.2833 6.09583 10.5208 6.2875 10.7125C6.47917 10.9042 6.71667 11 7 11ZM10 14C10.2833 14 10.5208 13.9042 10.7125 13.7125C10.9042 13.5208 11 13.2833 11 13C11 12.7167 10.9042 12.4792 10.7125 12.2875C10.5208 12.0958 10.2833 12 10 12C9.71667 12 9.47917 12.0958 9.2875 12.2875C9.09583 12.4792 9 12.7167 9 13C9 13.2833 9.09583 13.5208 9.2875 13.7125C9.47917 13.9042 9.71667 14 10 14ZM13 14C13.2833 14 13.5208 13.9042 13.7125 13.7125C13.9042 13.5208 14 13.2833 14 13C14 12.7167 13.9042 12.4792 13.7125 12.2875C13.5208 12.0958 13.2833 12 13 12C12.7167 12 12.4792 12.0958 12.2875 12.2875C12.0958 12.4792 12 12.7167 12 13C12 13.2833 12.0958 13.5208 12.2875 13.7125C12.4792 13.9042 12.7167 14 13 14ZM7 14C7.28333 14 7.52083 13.9042 7.7125 13.7125C7.90417 13.5208 8 13.2833 8 13C8 12.7167 7.90417 12.4792 7.7125 12.2875C7.52083 12.0958 7.28333 12 7 12C6.71667 12 6.47917 12.0958 6.2875 12.2875C6.09583 12.4792 6 12.7167 6 13C6 13.2833 6.09583 13.5208 6.2875 13.7125C6.47917 13.9042 6.71667 14 7 14ZM10 8C10.2833 8 10.5208 7.90417 10.7125 7.7125C10.9042 7.52083 11 7.28333 11 7C11 6.71667 10.9042 6.47917 10.7125 6.2875C10.5208 6.09583 10.2833 6 10 6C9.71667 6 9.47917 6.09583 9.2875 6.2875C9.09583 6.47917 9 6.71667 9 7C9 7.28333 9.09583 7.52083 9.2875 7.7125C9.47917 7.90417 9.71667 8 10 8ZM13 8C13.2833 8 13.5208 7.90417 13.7125 7.7125C13.9042 7.52083 14 7.28333 14 7C14 6.71667 13.9042 6.47917 13.7125 6.2875C13.5208 6.09583 13.2833 6 13 6C12.7167 6 12.4792 6.09583 12.2875 6.2875C12.0958 6.47917 12 6.71667 12 7C12 7.28333 12.0958 7.52083 12.2875 7.7125C12.4792 7.90417 12.7167 8 13 8ZM7 8C7.28333 8 7.52083 7.90417 7.7125 7.7125C7.90417 7.52083 8 7.28333 8 7C8 6.71667 7.90417 6.47917 7.7125 6.2875C7.52083 6.09583 7.28333 6 7 6C6.71667 6 6.47917 6.09583 6.2875 6.2875C6.09583 6.47917 6 6.71667 6 7C6 7.28333 6.09583 7.52083 6.2875 7.7125C6.47917 7.90417 6.71667 8 7 8ZM10 20C8.61667 20 7.31667 19.7375 6.1 19.2125C4.88333 18.6875 3.825 17.975 2.925 17.075C2.025 16.175 1.3125 15.1167 0.7875 13.9C0.2625 12.6833 0 11.3833 0 10C0 8.61667 0.2625 7.31667 0.7875 6.1C1.3125 4.88333 2.025 3.825 2.925 2.925C3.825 2.025 4.88333 1.3125 6.1 0.7875C7.31667 0.2625 8.61667 0 10 0C11.3833 0 12.6833 0.2625 13.9 0.7875C15.1167 1.3125 16.175 2.025 17.075 2.925C17.975 3.825 18.6875 4.88333 19.2125 6.1C19.7375 7.31667 20 8.61667 20 10C20 11.3833 19.7375 12.6833 19.2125 13.9C18.6875 15.1167 17.975 16.175 17.075 17.075C16.175 17.975 15.1167 18.6875 13.9 19.2125C12.6833 19.7375 11.3833 20 10 20Z"/> </svg>',
            ],
            'marketplace' => [
                'key' => 'marketplace',
                'icon' => null,
                'svg' =>
                    '<svg width="22" height="18" viewBox="0 0 22 18" fill="currentColor" xmlns="http://www.w3.org/2000/svg"> <path d="M20.0235 8.05V16C20.0235 16.55 19.8277 17.0208 19.436 17.4125C19.0443 17.8042 18.5735 18 18.0235 18H4.0235C3.4735 18 3.00267 17.8042 2.611 17.4125C2.21933 17.0208 2.0235 16.55 2.0235 16V8.05C1.64017 7.7 1.34433 7.25 1.136 6.7C0.927668 6.15 0.923501 5.55 1.1235 4.9L2.1735 1.5C2.30683 1.06667 2.54433 0.708333 2.886 0.425C3.22767 0.141667 3.6235 0 4.0735 0H17.9735C18.4235 0 18.8152 0.1375 19.1485 0.4125C19.4818 0.6875 19.7235 1.05 19.8735 1.5L20.9235 4.9C21.1235 5.55 21.1193 6.14167 20.911 6.675C20.7027 7.20833 20.4068 7.66667 20.0235 8.05ZM13.2235 7C13.6735 7 14.0152 6.84583 14.2485 6.5375C14.4818 6.22917 14.5735 5.88333 14.5235 5.5L13.9735 2H12.0235V5.7C12.0235 6.05 12.1402 6.35417 12.3735 6.6125C12.6068 6.87083 12.8902 7 13.2235 7ZM8.7235 7C9.10684 7 9.41934 6.87083 9.661 6.6125C9.90267 6.35417 10.0235 6.05 10.0235 5.7V2H8.0735L7.5235 5.5C7.45684 5.9 7.54433 6.25 7.786 6.55C8.02767 6.85 8.34017 7 8.7235 7ZM4.2735 7C4.5735 7 4.836 6.89167 5.061 6.675C5.286 6.45833 5.4235 6.18333 5.4735 5.85L6.0235 2H4.0735L3.0735 5.35C2.9735 5.68333 3.02767 6.04167 3.236 6.425C3.44433 6.80833 3.79017 7 4.2735 7ZM17.7735 7C18.2568 7 18.6068 6.80833 18.8235 6.425C19.0402 6.04167 19.0902 5.68333 18.9735 5.35L17.9235 2H16.0235L16.5735 5.85C16.6235 6.18333 16.761 6.45833 16.986 6.675C17.211 6.89167 17.4735 7 17.7735 7Z"/> </svg>',
            ],
            'themes' => [
                'key' => 'themes',
                'icon' => null,
                'svg' =>
                    '<svg width="20" height="20" viewBox="0 0 20 20" fill="currentColor" xmlns="http://www.w3.org/2000/svg"> <path d="M10 20C8.63333 20 7.34167 19.7375 6.125 19.2125C4.90833 18.6875 3.84583 17.9708 2.9375 17.0625C2.02917 16.1542 1.3125 15.0917 0.7875 13.875C0.2625 12.6583 0 11.3667 0 10C0 8.61667 0.270833 7.31667 0.8125 6.1C1.35417 4.88333 2.0875 3.825 3.0125 2.925C3.9375 2.025 5.01667 1.3125 6.25 0.7875C7.48333 0.2625 8.8 0 10.2 0C11.5333 0 12.7917 0.229167 13.975 0.6875C15.1583 1.14583 16.1958 1.77917 17.0875 2.5875C17.9792 3.39583 18.6875 4.35417 19.2125 5.4625C19.7375 6.57083 20 7.76667 20 9.05C20 10.9667 19.4167 12.4375 18.25 13.4625C17.0833 14.4875 15.6667 15 14 15H12.15C12 15 11.8958 15.0417 11.8375 15.125C11.7792 15.2083 11.75 15.3 11.75 15.4C11.75 15.6 11.875 15.8875 12.125 16.2625C12.375 16.6375 12.5 17.0667 12.5 17.55C12.5 18.3833 12.2708 19 11.8125 19.4C11.3542 19.8 10.75 20 10 20ZM4.5 11C4.93333 11 5.29167 10.8583 5.575 10.575C5.85833 10.2917 6 9.93333 6 9.5C6 9.06667 5.85833 8.70833 5.575 8.425C5.29167 8.14167 4.93333 8 4.5 8C4.06667 8 3.70833 8.14167 3.425 8.425C3.14167 8.70833 3 9.06667 3 9.5C3 9.93333 3.14167 10.2917 3.425 10.575C3.70833 10.8583 4.06667 11 4.5 11ZM7.5 7C7.93333 7 8.29167 6.85833 8.575 6.575C8.85833 6.29167 9 5.93333 9 5.5C9 5.06667 8.85833 4.70833 8.575 4.425C8.29167 4.14167 7.93333 4 7.5 4C7.06667 4 6.70833 4.14167 6.425 4.425C6.14167 4.70833 6 5.06667 6 5.5C6 5.93333 6.14167 6.29167 6.425 6.575C6.70833 6.85833 7.06667 7 7.5 7ZM12.5 7C12.9333 7 13.2917 6.85833 13.575 6.575C13.8583 6.29167 14 5.93333 14 5.5C14 5.06667 13.8583 4.70833 13.575 4.425C13.2917 4.14167 12.9333 4 12.5 4C12.0667 4 11.7083 4.14167 11.425 4.425C11.1417 4.70833 11 5.06667 11 5.5C11 5.93333 11.1417 6.29167 11.425 6.575C11.7083 6.85833 12.0667 7 12.5 7ZM15.5 11C15.9333 11 16.2917 10.8583 16.575 10.575C16.8583 10.2917 17 9.93333 17 9.5C17 9.06667 16.8583 8.70833 16.575 8.425C16.2917 8.14167 15.9333 8 15.5 8C15.0667 8 14.7083 8.14167 14.425 8.425C14.1417 8.70833 14 9.06667 14 9.5C14 9.93333 14.1417 10.2917 14.425 10.575C14.7083 10.8583 15.0667 11 15.5 11Z"/> </svg>',
            ],
            'user_management' => [
                'key' => 'user_management',
                'icon' => null,
                'svg' =>
                    '<svg width="24" height="12" viewBox="0 0 24 12" fill="currentColor" xmlns="http://www.w3.org/2000/svg"> <path d="M0 12V10.425C0 9.70833 0.366667 9.125 1.1 8.675C1.83333 8.225 2.8 8 4 8C4.21667 8 4.425 8.00417 4.625 8.0125C4.825 8.02083 5.01667 8.04167 5.2 8.075C4.96667 8.425 4.79167 8.79167 4.675 9.175C4.55833 9.55833 4.5 9.95833 4.5 10.375V12H0ZM6 12V10.375C6 9.84167 6.14583 9.35417 6.4375 8.9125C6.72917 8.47083 7.14167 8.08333 7.675 7.75C8.20833 7.41667 8.84583 7.16667 9.5875 7C10.3292 6.83333 11.1333 6.75 12 6.75C12.8833 6.75 13.6958 6.83333 14.4375 7C15.1792 7.16667 15.8167 7.41667 16.35 7.75C16.8833 8.08333 17.2917 8.47083 17.575 8.9125C17.8583 9.35417 18 9.84167 18 10.375V12H6ZM19.5 12V10.375C19.5 9.94167 19.4458 9.53333 19.3375 9.15C19.2292 8.76667 19.0667 8.40833 18.85 8.075C19.0333 8.04167 19.2208 8.02083 19.4125 8.0125C19.6042 8.00417 19.8 8 20 8C21.2 8 22.1667 8.22083 22.9 8.6625C23.6333 9.10417 24 9.69167 24 10.425V12H19.5ZM4 7C3.45 7 2.97917 6.80417 2.5875 6.4125C2.19583 6.02083 2 5.55 2 5C2 4.43333 2.19583 3.95833 2.5875 3.575C2.97917 3.19167 3.45 3 4 3C4.56667 3 5.04167 3.19167 5.425 3.575C5.80833 3.95833 6 4.43333 6 5C6 5.55 5.80833 6.02083 5.425 6.4125C5.04167 6.80417 4.56667 7 4 7ZM20 7C19.45 7 18.9792 6.80417 18.5875 6.4125C18.1958 6.02083 18 5.55 18 5C18 4.43333 18.1958 3.95833 18.5875 3.575C18.9792 3.19167 19.45 3 20 3C20.5667 3 21.0417 3.19167 21.425 3.575C21.8083 3.95833 22 4.43333 22 5C22 5.55 21.8083 6.02083 21.425 6.4125C21.0417 6.80417 20.5667 7 20 7ZM12 6C11.1667 6 10.4583 5.70833 9.875 5.125C9.29167 4.54167 9 3.83333 9 3C9 2.15 9.29167 1.4375 9.875 0.8625C10.4583 0.2875 11.1667 0 12 0C12.85 0 13.5625 0.2875 14.1375 0.8625C14.7125 1.4375 15 2.15 15 3C15 3.83333 14.7125 4.54167 14.1375 5.125C13.5625 5.70833 12.85 6 12 6Z"/> </svg>',
            ],
            'google_adsense' => [
                'key' => 'google_adsense',
                'icon' => null,
                'svg' =>
                    '<svg width="18" height="18" viewBox="0 0 18 18" fill="currentColor" xmlns="http://www.w3.org/2000/svg"> <path d="M2 18C1.45 18 0.979167 17.8042 0.5875 17.4125C0.195833 17.0208 0 16.55 0 16V2C0 1.45 0.195833 0.979167 0.5875 0.5875C0.979167 0.195833 1.45 0 2 0H16C16.55 0 17.0208 0.195833 17.4125 0.5875C17.8042 0.979167 18 1.45 18 2V16C18 16.55 17.8042 17.0208 17.4125 17.4125C17.0208 17.8042 16.55 18 16 18H2ZM16 4.25L9.95 11.05L6 7.1L2 11.1V13.95L6 9.95L10.05 14L16 7.25V4.25Z"/> </svg>',
            ],
            'support_requests' => [
                'key' => 'support_requests',
                'icon' => null,
                'svg' =>
                    '<svg width="20" height="20" viewBox="0 0 20 20" fill="currentColor" xmlns="http://www.w3.org/2000/svg"> <path d="M10 20C8.61667 20 7.31667 19.7375 6.1 19.2125C4.88333 18.6875 3.825 17.975 2.925 17.075C2.025 16.175 1.3125 15.1167 0.7875 13.9C0.2625 12.6833 0 11.3833 0 10C0 8.61667 0.2625 7.31667 0.7875 6.1C1.3125 4.88333 2.025 3.825 2.925 2.925C3.825 2.025 4.88333 1.3125 6.1 0.7875C7.31667 0.2625 8.61667 0 10 0C11.3833 0 12.6833 0.2625 13.9 0.7875C15.1167 1.3125 16.175 2.025 17.075 2.925C17.975 3.825 18.6875 4.88333 19.2125 6.1C19.7375 7.31667 20 8.61667 20 10C20 11.3833 19.7375 12.6833 19.2125 13.9C18.6875 15.1167 17.975 16.175 17.075 17.075C16.175 17.975 15.1167 18.6875 13.9 19.2125C12.6833 19.7375 11.3833 20 10 20ZM7.1 17.45L8.3 14.7C7.6 14.45 6.99583 14.0625 6.4875 13.5375C5.97917 13.0125 5.58333 12.4 5.3 11.7L2.55 12.85C2.93333 13.9167 3.525 14.85 4.325 15.65C5.125 16.45 6.05 17.05 7.1 17.45ZM5.3 8.3C5.58333 7.6 5.97917 6.9875 6.4875 6.4625C6.99583 5.9375 7.6 5.55 8.3 5.3L7.15 2.55C6.08333 2.95 5.15 3.55 4.35 4.35C3.55 5.15 2.95 6.08333 2.55 7.15L5.3 8.3ZM10 13C10.8333 13 11.5417 12.7083 12.125 12.125C12.7083 11.5417 13 10.8333 13 10C13 9.16667 12.7083 8.45833 12.125 7.875C11.5417 7.29167 10.8333 7 10 7C9.16667 7 8.45833 7.29167 7.875 7.875C7.29167 8.45833 7 9.16667 7 10C7 10.8333 7.29167 11.5417 7.875 12.125C8.45833 12.7083 9.16667 13 10 13ZM12.9 17.45C13.95 17.05 14.8708 16.4542 15.6625 15.6625C16.4542 14.8708 17.05 13.95 17.45 12.9L14.7 11.7C14.45 12.4 14.0667 13.0042 13.55 13.5125C13.0333 14.0208 12.4333 14.4167 11.75 14.7L12.9 17.45ZM14.7 8.25L17.45 7.1C17.05 6.05 16.4542 5.12917 15.6625 4.3375C14.8708 3.54583 13.95 2.95 12.9 2.55L11.75 5.35C12.4333 5.6 13.025 5.97917 13.525 6.4875C14.025 6.99583 14.4167 7.58333 14.7 8.25Z"/> </svg>',
            ],
            'templates' => [
                'key' => 'templates',
                'icon' => null,
                'svg' =>
                    '<svg width="22" height="22" viewBox="0 0 22 22" fill="currentColor" xmlns="http://www.w3.org/2000/svg"> <path d="M20.6 22L17.525 18.95C17.225 19.1333 16.9042 19.2708 16.5625 19.3625C16.2208 19.4542 15.8667 19.5 15.5 19.5C14.4 19.5 13.4583 19.1083 12.675 18.325C11.8917 17.5417 11.5 16.6 11.5 15.5C11.5 14.4 11.8917 13.4583 12.675 12.675C13.4583 11.8917 14.4 11.5 15.5 11.5C16.6 11.5 17.5417 11.8917 18.325 12.675C19.1083 13.4583 19.5 14.4 19.5 15.5C19.5 15.8833 19.45 16.2458 19.35 16.5875C19.25 16.9292 19.1083 17.25 18.925 17.55L22 20.6L20.6 22ZM4.5 19.5C3.4 19.5 2.45833 19.1083 1.675 18.325C0.891667 17.5417 0.5 16.6 0.5 15.5C0.5 14.4 0.891667 13.4583 1.675 12.675C2.45833 11.8917 3.4 11.5 4.5 11.5C5.6 11.5 6.54167 11.8917 7.325 12.675C8.10833 13.4583 8.5 14.4 8.5 15.5C8.5 16.6 8.10833 17.5417 7.325 18.325C6.54167 19.1083 5.6 19.5 4.5 19.5ZM15.5 17.5C16.05 17.5 16.5208 17.3042 16.9125 16.9125C17.3042 16.5208 17.5 16.05 17.5 15.5C17.5 14.95 17.3042 14.4792 16.9125 14.0875C16.5208 13.6958 16.05 13.5 15.5 13.5C14.95 13.5 14.4792 13.6958 14.0875 14.0875C13.6958 14.4792 13.5 14.95 13.5 15.5C13.5 16.05 13.6958 16.5208 14.0875 16.9125C14.4792 17.3042 14.95 17.5 15.5 17.5ZM4.5 8.5C3.4 8.5 2.45833 8.10833 1.675 7.325C0.891667 6.54167 0.5 5.6 0.5 4.5C0.5 3.4 0.891667 2.45833 1.675 1.675C2.45833 0.891667 3.4 0.5 4.5 0.5C5.6 0.5 6.54167 0.891667 7.325 1.675C8.10833 2.45833 8.5 3.4 8.5 4.5C8.5 5.6 8.10833 6.54167 7.325 7.325C6.54167 8.10833 5.6 8.5 4.5 8.5ZM15.5 8.5C14.4 8.5 13.4583 8.10833 12.675 7.325C11.8917 6.54167 11.5 5.6 11.5 4.5C11.5 3.4 11.8917 2.45833 12.675 1.675C13.4583 0.891667 14.4 0.5 15.5 0.5C16.6 0.5 17.5417 0.891667 18.325 1.675C19.1083 2.45833 19.5 3.4 19.5 4.5C19.5 5.6 19.1083 6.54167 18.325 7.325C17.5417 8.10833 16.6 8.5 15.5 8.5Z"/> </svg>',
            ],
            'finance' => [
                'key' => 'finance',
                'icon' => null,
                'svg' =>
                    '<svg width="20" height="20" viewBox="0 0 20 20" fill="currentColor" xmlns="http://www.w3.org/2000/svg"> <path d="M3 16V9H5V16H3ZM9 16V9H11V16H9ZM0 20V18H20V20H0ZM15 16V9H17V16H15ZM0 7V5L10 0L20 5V7H0Z" /> </svg>',
            ],
            'pages' => [
                'key' => 'pages',
                'icon' => null,
                'svg' =>
                    '<svg width="16" height="20" viewBox="0 0 16 20" fill="currentColor" xmlns="http://www.w3.org/2000/svg"> <path d="M4 10H12V8H4V10ZM4 6H12V4H4V6ZM15.95 18.475L11.9 13.2C11.6167 12.8167 11.2667 12.5208 10.85 12.3125C10.4333 12.1042 9.98333 12 9.5 12H0V2C0 1.45 0.195833 0.979167 0.5875 0.5875C0.979167 0.195833 1.45 0 2 0H14C14.55 0 15.0208 0.195833 15.4125 0.5875C15.8042 0.979167 16 1.45 16 2V18C16 18.0833 15.9958 18.1625 15.9875 18.2375C15.9792 18.3125 15.9667 18.3917 15.95 18.475ZM2 20C1.45 20 0.979167 19.8042 0.5875 19.4125C0.195833 19.0208 0 18.55 0 18V14H9.5C9.66667 14 9.82083 14.0375 9.9625 14.1125C10.1042 14.1875 10.225 14.2917 10.325 14.425L14.525 19.925C14.4417 19.9583 14.3542 19.9792 14.2625 19.9875C14.1708 19.9958 14.0833 20 14 20H2Z"/> </svg>',
            ],
            'blog' => [
                'key' => 'blog',
                'icon' => null,
                'svg' =>
                    '<svg width="20" height="18" viewBox="0 0 20 18" fill="currentColor" xmlns="http://www.w3.org/2000/svg"> <path d="M2 18C1.45 18 0.979167 17.8042 0.5875 17.4125C0.195833 17.0208 0 16.55 0 16V2C0 1.45 0.195833 0.979167 0.5875 0.5875C0.979167 0.195833 1.45 0 2 0H18C18.55 0 19.0208 0.195833 19.4125 0.5875C19.8042 0.979167 20 1.45 20 2V16C20 16.55 19.8042 17.0208 19.4125 17.4125C19.0208 17.8042 18.55 18 18 18H2ZM4 14H16V12H4V14ZM4 10H8V4H4V10ZM10 10H16V8H10V10ZM10 6H16V4H10V6Z"/> </svg>',
            ],
            'affiliates_admin' => [
                'key' => 'affiliates_admin',
                'icon' => null,
                'svg' =>
                    '<svg width="20" height="21" viewBox="0 0 20 21" fill="currentColor" xmlns="http://www.w3.org/2000/svg"> <path d="M2 21V10H0V4H5.2C5.11667 3.85 5.0625 3.69167 5.0375 3.525C5.0125 3.35833 5 3.18333 5 3C5 2.16667 5.29167 1.45833 5.875 0.875C6.45833 0.291667 7.16667 0 8 0C8.38333 0 8.74167 0.0708333 9.075 0.2125C9.40833 0.354167 9.71667 0.55 10 0.8C10.2833 0.533333 10.5917 0.333333 10.925 0.2C11.2583 0.0666667 11.6167 0 12 0C12.8333 0 13.5417 0.291667 14.125 0.875C14.7083 1.45833 15 2.16667 15 3C15 3.18333 14.9833 3.35417 14.95 3.5125C14.9167 3.67083 14.8667 3.83333 14.8 4H20V10H18V21H2ZM12 2C11.7167 2 11.4792 2.09583 11.2875 2.2875C11.0958 2.47917 11 2.71667 11 3C11 3.28333 11.0958 3.52083 11.2875 3.7125C11.4792 3.90417 11.7167 4 12 4C12.2833 4 12.5208 3.90417 12.7125 3.7125C12.9042 3.52083 13 3.28333 13 3C13 2.71667 12.9042 2.47917 12.7125 2.2875C12.5208 2.09583 12.2833 2 12 2ZM7 3C7 3.28333 7.09583 3.52083 7.2875 3.7125C7.47917 3.90417 7.71667 4 8 4C8.28333 4 8.52083 3.90417 8.7125 3.7125C8.90417 3.52083 9 3.28333 9 3C9 2.71667 8.90417 2.47917 8.7125 2.2875C8.52083 2.09583 8.28333 2 8 2C7.71667 2 7.47917 2.09583 7.2875 2.2875C7.09583 2.47917 7 2.71667 7 3ZM2 6V8H9V6H2ZM9 19V10H4V19H9ZM11 19H16V10H11V19ZM18 8V6H11V8H18Z"/> </svg>',
            ],
            'coupons_admin' => [
                'key' => 'coupons_admin',
                'icon' => null,
                'svg' =>
                    '<svg width="16" height="16" viewBox="0 0 16 16" fill="currentColor" xmlns="http://www.w3.org/2000/svg"> <path d="M3.5 7C2.53333 7 1.70833 6.65833 1.025 5.975C0.341667 5.29167 0 4.46667 0 3.5C0 2.53333 0.341667 1.70833 1.025 1.025C1.70833 0.341667 2.53333 0 3.5 0C4.46667 0 5.29167 0.341667 5.975 1.025C6.65833 1.70833 7 2.53333 7 3.5C7 4.46667 6.65833 5.29167 5.975 5.975C5.29167 6.65833 4.46667 7 3.5 7ZM3.5 5C3.91667 5 4.27083 4.85417 4.5625 4.5625C4.85417 4.27083 5 3.91667 5 3.5C5 3.08333 4.85417 2.72917 4.5625 2.4375C4.27083 2.14583 3.91667 2 3.5 2C3.08333 2 2.72917 2.14583 2.4375 2.4375C2.14583 2.72917 2 3.08333 2 3.5C2 3.91667 2.14583 4.27083 2.4375 4.5625C2.72917 4.85417 3.08333 5 3.5 5ZM12.5 16C11.5333 16 10.7083 15.6583 10.025 14.975C9.34167 14.2917 9 13.4667 9 12.5C9 11.5333 9.34167 10.7083 10.025 10.025C10.7083 9.34167 11.5333 9 12.5 9C13.4667 9 14.2917 9.34167 14.975 10.025C15.6583 10.7083 16 11.5333 16 12.5C16 13.4667 15.6583 14.2917 14.975 14.975C14.2917 15.6583 13.4667 16 12.5 16ZM12.5 14C12.9167 14 13.2708 13.8542 13.5625 13.5625C13.8542 13.2708 14 12.9167 14 12.5C14 12.0833 13.8542 11.7292 13.5625 11.4375C13.2708 11.1458 12.9167 11 12.5 11C12.0833 11 11.7292 11.1458 11.4375 11.4375C11.1458 11.7292 11 12.0833 11 12.5C11 12.9167 11.1458 13.2708 11.4375 13.5625C11.7292 13.8542 12.0833 14 12.5 14ZM1.4 16L0 14.6L14.6 0L16 1.4L1.4 16Z"/> </svg>',
            ],
            'email_templates' => [
                'key' => 'email_templates',
                'icon' => null,
                'svg' =>
                    '<svg width="20" height="16" viewBox="0 0 20 16" fill="currentColor" xmlns="http://www.w3.org/2000/svg"> <path d="M2 16C1.45 16 0.979167 15.8042 0.5875 15.4125C0.195833 15.0208 0 14.55 0 14V2C0 1.45 0.195833 0.979167 0.5875 0.5875C0.979167 0.195833 1.45 0 2 0H18C18.55 0 19.0208 0.195833 19.4125 0.5875C19.8042 0.979167 20 1.45 20 2V14C20 14.55 19.8042 15.0208 19.4125 15.4125C19.0208 15.8042 18.55 16 18 16H2ZM10 9L18 4V2L10 7L2 2V4L10 9Z"/> </svg>',
            ],
            'api_integration' => [
                'key' => 'api_integration',
                'icon' => 'tabler-api',
                'svg' => null,
            ],
            'settings' => [
                'key' => 'settings',
                'icon' => null,
                'svg' =>
                    '<svg width="22" height="20" viewBox="0 0 22 20" fill="currentColor" xmlns="http://www.w3.org/2000/svg"> <path d="M13.2492 19.95C12.9326 20.0333 12.6451 19.9792 12.3867 19.7875C12.1284 19.5958 11.9992 19.3333 11.9992 19V14C11.9992 13.6667 12.1284 13.4042 12.3867 13.2125C12.6451 13.0208 12.9409 12.9667 13.2742 13.05C13.8909 13.2167 14.5076 13.3333 15.1242 13.4C15.7409 13.4667 16.3659 13.5 16.9992 13.5C17.6326 13.5 18.2617 13.4667 18.8867 13.4C19.5117 13.3333 20.1326 13.2167 20.7492 13.05C21.0659 12.9667 21.3534 13.0208 21.6117 13.2125C21.8701 13.4042 21.9992 13.6667 21.9992 14V19C21.9992 19.3333 21.8701 19.5958 21.6117 19.7875C21.3534 19.9792 21.0659 20.0333 20.7492 19.95C20.1326 19.7833 19.5117 19.6667 18.8867 19.6C18.2617 19.5333 17.6326 19.5 16.9992 19.5C16.3659 19.5 15.7367 19.5333 15.1117 19.6C14.4867 19.6667 13.8659 19.7833 13.2492 19.95ZM8.24922 20L7.84922 16.8C7.63255 16.7167 7.42839 16.6167 7.23672 16.5C7.04505 16.3833 6.85755 16.2583 6.67422 16.125L3.69922 17.375L0.949219 12.625L3.52422 10.675C3.50755 10.5583 3.49922 10.4458 3.49922 10.3375V9.6625C3.49922 9.55417 3.50755 9.44167 3.52422 9.325L0.949219 7.375L3.69922 2.625L6.67422 3.875C6.85755 3.74167 7.04922 3.61667 7.24922 3.5C7.44922 3.38333 7.64922 3.28333 7.84922 3.2L8.24922 0H13.7492L14.1492 3.2C14.3659 3.28333 14.5701 3.38333 14.7617 3.5C14.9534 3.61667 15.1409 3.74167 15.3242 3.875L18.2992 2.625L21.0492 7.375L18.4742 9.325C18.4909 9.44167 18.4992 9.55417 18.4992 9.6625V10.5C18.4992 10.6667 18.4826 10.8333 18.4492 11H14.3992C14.4492 10.8333 14.4867 10.6708 14.5117 10.5125C14.5367 10.3542 14.5492 10.1833 14.5492 10C14.5492 9.03333 14.2076 8.20833 13.5242 7.525C12.8409 6.84167 12.0159 6.5 11.0492 6.5C10.0659 6.5 9.23672 6.84167 8.56172 7.525C7.88672 8.20833 7.54922 9.03333 7.54922 10C7.54922 10.8 7.77839 11.5 8.23672 12.1C8.69505 12.7 9.28255 13.1167 9.99922 13.35V20H8.24922Z"/> </svg>',
            ],
            'site_health' => [
                'key' => 'site_health',
                'icon' => null,
                'svg' =>
                    '<svg width="20" height="19" viewBox="0 0 20 19" fill="currentColor" xmlns="http://www.w3.org/2000/svg"> <path d="M8.7 9.725L7.85 8.45C7.76667 8.31667 7.65 8.20833 7.5 8.125C7.35 8.04167 7.19167 8 7.025 8H0.475C0.291667 7.56667 0.166667 7.15 0.1 6.75C0.0333333 6.35 0 5.93333 0 5.5C0 3.93333 0.525 2.625 1.575 1.575C2.625 0.525 3.93333 0 5.5 0C6.36667 0 7.19167 0.183333 7.975 0.55C8.75833 0.916667 9.43333 1.43333 10 2.1C10.5667 1.43333 11.2417 0.916667 12.025 0.55C12.8083 0.183333 13.6333 0 14.5 0C16.0667 0 17.375 0.525 18.425 1.575C19.475 2.625 20 3.93333 20 5.5C20 5.93333 19.9667 6.35 19.9 6.75C19.8333 7.15 19.7083 7.56667 19.525 8H13.575L11.85 5.45C11.75 5.3 11.6208 5.1875 11.4625 5.1125C11.3042 5.0375 11.1333 5 10.95 5C10.7333 5 10.5458 5.0625 10.3875 5.1875C10.2292 5.3125 10.1167 5.475 10.05 5.675L8.7 9.725ZM10 18.35L8.55 17.05C6.8 15.4833 5.36667 14.1417 4.25 13.025C3.13333 11.9083 2.25833 10.9 1.625 10H6.425L8.15 12.55C8.25 12.7 8.37917 12.8125 8.5375 12.8875C8.69583 12.9625 8.86667 13 9.05 13C9.26667 13 9.45417 12.9375 9.6125 12.8125C9.77083 12.6875 9.88333 12.525 9.95 12.325L11.3 8.25L12.175 9.55C12.2583 9.68333 12.375 9.79167 12.525 9.875C12.675 9.95833 12.8333 10 13 10H18.375C17.7417 10.9 16.8667 11.9083 15.75 13.025C14.6333 14.1417 13.2 15.4833 11.45 17.05L10 18.35Z"/> </svg>',
            ],
            'license' => [
                'key' => 'license',
                'icon' => null,
                'svg' =>
                    '<svg width="20" height="16" viewBox="0 0 20 16" fill="currentColor" xmlns="http://www.w3.org/2000/svg"> <path d="M12 9H17V7H12V9ZM12 6H17V4H12V6ZM3 12H11V11.45C11 10.7 10.6333 10.1042 9.9 9.6625C9.16667 9.22083 8.2 9 7 9C5.8 9 4.83333 9.22083 4.1 9.6625C3.36667 10.1042 3 10.7 3 11.45V12ZM7 8C7.55 8 8.02083 7.80417 8.4125 7.4125C8.80417 7.02083 9 6.55 9 6C9 5.45 8.80417 4.97917 8.4125 4.5875C8.02083 4.19583 7.55 4 7 4C6.45 4 5.97917 4.19583 5.5875 4.5875C5.19583 4.97917 5 5.45 5 6C5 6.55 5.19583 7.02083 5.5875 7.4125C5.97917 7.80417 6.45 8 7 8ZM2 16C1.45 16 0.979167 15.8042 0.5875 15.4125C0.195833 15.0208 0 14.55 0 14V2C0 1.45 0.195833 0.979167 0.5875 0.5875C0.979167 0.195833 1.45 0 2 0H18C18.55 0 19.0208 0.195833 19.4125 0.5875C19.8042 0.979167 20 1.45 20 2V14C20 14.55 19.8042 15.0208 19.4125 15.4125C19.0208 15.8042 18.55 16 18 16H2Z"/> </svg>',
            ],
            'update' => [
                'key' => 'update',
                'icon' => null,
                'svg' =>
                    '<svg width="20" height="16" viewBox="0 0 20 16" fill="currentColor" xmlns="http://www.w3.org/2000/svg"> <path d="M2 16C1.45 16 0.979167 15.8042 0.5875 15.4125C0.195833 15.0208 0 14.55 0 14V2C0 1.45 0.195833 0.979167 0.5875 0.5875C0.979167 0.195833 1.45 0 2 0H7V2H2V14H18V2H13V0H18C18.55 0 19.0208 0.195833 19.4125 0.5875C19.8042 0.979167 20 1.45 20 2V14C20 14.55 19.8042 15.0208 19.4125 15.4125C19.0208 15.8042 18.55 16 18 16H2ZM10 11.4L5 6.4L6.4 5L9 7.6V0H11V7.6L13.6 5L15 6.4L10 11.4Z"/> </svg>',
            ],
            'menu_setting' => [
                'key' => 'menu_setting',
                'icon' => null,
                'svg' =>
                    '<svg xmlns="http://www.w3.org/2000/svg" height="24px" viewBox="0 -960 960 960" width="24px" fill="currentColor"><path d="M160-360v-80h640v80H160Zm0-160v-80h640v80H160Z"/></svg>',
            ],
            'mega_menu_setting' => [
                'key' => 'mega_menu_setting',
                'icon' => null,
                'svg' =>
                    '<svg xmlns="http://www.w3.org/2000/svg" height="24px" viewBox="0 -960 960 960" width="24px" fill="currentColor"><path d="M160-160q-33 0-56.5-23.5T80-240v-480q0-33 23.5-56.5T160-800h53q33 0 56.5 23.5T293-720v480q0 33-23.5 56.5T213-160h-53Zm294 0q-33 0-56.5-23.5T374-240v-480q0-33 23.5-56.5T454-800h53q33 0 56.5 23.5T587-720v480q0 33-23.5 56.5T507-160h-53Zm293 0q-33 0-56.5-23.5T667-240v-480q0-33 23.5-56.5T747-800h53q33 0 56.5 23.5T880-720v480q0 33-23.5 56.5T800-160h-53Z"/></svg>',
            ],
            'integration' => [
                'key' => 'integration',
                'icon' => null,
                'svg' =>
                    '<svg xmlns="http://www.w3.org/2000/svg" height="24px" viewBox="0 -960 960 960" width="24px" fill="currentColor"><path d="m384-336 56-58-86-86 86-86-56-58-144 144 144 144Zm192 0 144-144-144-144-56 58 86 86-86 86 56 58ZM200-120q-33 0-56.5-23.5T120-200v-560q0-33 23.5-56.5T200-840h168q13-36 43.5-58t68.5-22q38 0 68.5 22t43.5 58h168q33 0 56.5 23.5T840-760v560q0 33-23.5 56.5T760-120H200Zm280-670q13 0 21.5-8.5T510-820q0-13-8.5-21.5T480-850q-13 0-21.5 8.5T450-820q0 13 8.5 21.5T480-790Z"/></svg>',
            ],
            'site_promo' => [
                'key' => 'site_promo',
                'icon' => null,
                'svg' =>
                    '<svg width="22" height="22" viewBox="0 0 22 22" fill="currentColor" xmlns="http://www.w3.org/2000/svg"> <path d="M21.1124 11.1002C20.9954 10.9145 20.7897 10.8025 20.5711 10.8025H13.863L9.23631 20.7435C9.13079 20.9704 8.90308 21.1149 8.65375 21.1149L16.3675 21.115C16.6169 21.115 16.8443 20.9705 16.9497 20.7435L21.1536 11.7201C21.2462 11.5203 21.2305 11.2858 21.1124 11.1002Z"/> <path d="M17.1255 1.40783C17.218 1.20809 17.2038 0.973388 17.0857 0.787763C16.9674 0.602091 16.7629 0.490013 16.543 0.490013H10.1152C9.8658 0.490013 9.63831 0.634388 9.53298 0.862482L0.533873 20.1981C0.441107 20.398 0.455498 20.6314 0.57367 20.8171C0.691842 21.0026 0.896357 21.1149 1.11615 21.1149H7.54389C7.79322 21.1149 8.02094 20.9704 8.12645 20.7435L17.1255 1.40783Z"/> </svg>',
            ],
        ];
        $defaultItems = (new \App\Services\Common\MenuService())->data();
        $defaultItem = data_get($defaultItems, $item['key']);
        if (data_get($defaultItem, 'key') == data_get($item, 'key')) {
            $classicData = data_get($classicThemeSet, $defaultItem['key']);
            if ($classicData) {
                // if the icon didnt change in db from default then keep classic theme default icon, else use the icon that user choosed
                if ($item['icon'] == $defaultItem['icon']) {
                    $icon = $classicData['icon'];
                    $item['svg'] = $classicData['svg'];
                }
            }
        }
    @endphp

    <x-navbar.item>
        <x-navbar.link
            class:letter-icon="{{ $item['letter_icon_bg'] }}"
            class="{{ data_get($item, 'class') }}"
            letter-icon-styles="{{ $item['letter_icon_bg'] }}"
            label="{{ __($item['label']) }}"
            href="{{ $item['route'] }}"
            slug="{{ $item['route_slug'] }}"
            icon="{{ $item['icon'] }}"
            iconHtml="{!! $item['svg'] !!}"
            active-condition="{{ $is_active }}"
            letter-icon="{{ (int) $item['letter_icon'] }}"
            onclick="{{ data_get($item, 'onclick') ?? '' }}"
            badge="{{ data_get($item, 'badge') ?? '' }}"
        />
    </x-navbar.item>
@endif
